/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.util.Enums;
import java.util.Map;
import java.util.Objects;

public enum RunType implements IntValueEnum<RunType>
{
    SCHEDULE(1, 0L, "\u8c03\u5ea6\u8ba1\u5212"),
    DEPEND(2, null, "\u4efb\u52a1\u4f9d\u8d56"),
    RETRY(3, null, "\u5931\u8d25\u91cd\u8bd5"),
    MANUAL(4, 0L, "\u624b\u52a8\u89e6\u53d1");

    private final int value;
    private final Long uniqueFlag;
    private final String desc;

    private RunType(int value, Long uniqueFlag, String desc) {
        this.value = value;
        this.uniqueFlag = uniqueFlag;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public boolean isUniqueFlag() {
        return this.uniqueFlag != null;
    }

    public long getUniqueFlag() {
        if (this.isUniqueFlag()) {
            return this.uniqueFlag;
        }
        throw new UnsupportedOperationException((Object)((Object)this) + " cannot supported unique flag.");
    }

    public static RunType of(Integer value) {
        return (RunType)((Object)Objects.requireNonNull(Const.MAPPING.get(value), () -> "Invalid run type value: " + value));
    }

    private static final class Const {
        private static final Map<Integer, RunType> MAPPING = Enums.toMap(RunType.class, RunType::value);

        private Const() {
        }
    }
}

