/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.date.CronExpression;
import cn.ponfee.disjob.common.date.DatePeriods;
import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.common.util.Enums;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.core.model.PeriodTriggerValue;
import cn.ponfee.disjob.core.model.SchedDepend;
import com.google.common.collect.ImmutableList;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public enum TriggerType implements IntValueEnum<TriggerType>
{
    CRON(1, "0/10 * * * * ?", "Cron\u8868\u8fbe\u5f0f"){

        @Override
        public boolean validate0(String triggerValue) {
            return CronExpression.isValidExpression((String)triggerValue);
        }

        @Override
        public Date computeNextTriggerTime(String triggerValue, Date startTime) {
            try {
                return new CronExpression(triggerValue).getNextValidTimeAfter(startTime);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid cron expression: " + triggerValue, e);
            }
        }

        @Override
        public List<Date> computeNextTriggerTimes(String triggerValue, Date startTime, int count) {
            CronExpression cronExpression;
            ArrayList<Date> result = new ArrayList<Date>(count);
            try {
                cronExpression = new CronExpression(triggerValue);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid cron expression: " + triggerValue, e);
            }
            while (count-- > 0 && (startTime = cronExpression.getNextValidTimeAfter(startTime)) != null) {
                result.add(startTime);
            }
            return result;
        }
    }
    ,
    ONCE(2, "2000-01-01 00:00:00", "\u6307\u5b9a\u65f6\u95f4"){

        @Override
        public boolean validate0(String triggerValue) {
            try {
                Dates.DATETIME_FORMAT.parse(triggerValue);
                return true;
            }
            catch (Exception ignored) {
                return false;
            }
        }

        @Override
        public Date computeNextTriggerTime(String triggerValue, Date startTime) {
            try {
                Date dateTime = Dates.DATETIME_FORMAT.parse(triggerValue);
                return dateTime.after(startTime) ? dateTime : null;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid once date format: " + triggerValue, e);
            }
        }

        @Override
        public List<Date> computeNextTriggerTimes(String triggerValue, Date startTime, int count) {
            Assert.isTrue((count == 1 ? 1 : 0) != 0, () -> this.name() + " unsupported compute multiple next trigger time: " + count);
            Date nextTriggerTime = this.computeNextTriggerTime(triggerValue, startTime);
            return nextTriggerTime == null ? Collections.emptyList() : Collections.singletonList(nextTriggerTime);
        }
    }
    ,
    PERIOD(3, "{\"period\":\"DAILY\", \"start\":\"2000-01-01 00:00:00\", \"step\":1}", "\u56fa\u5b9a\u5468\u671f"){

        @Override
        public boolean validate0(String triggerValue) {
            try {
                PeriodTriggerValue conf = (PeriodTriggerValue)Jsons.fromJson((String)triggerValue, PeriodTriggerValue.class);
                return conf != null && conf.verify();
            }
            catch (Exception ignored) {
                return false;
            }
        }

        @Override
        public Date computeNextTriggerTime(String triggerValue, Date startTime) {
            List<Date> list = this.computeNextTriggerTimes(triggerValue, startTime, 1);
            if (CollectionUtils.isEmpty(list)) {
                return null;
            }
            Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, () -> this.name() + " compute too many next trigger time.");
            return list.get(0);
        }

        @Override
        public List<Date> computeNextTriggerTimes(String triggerValue, Date startTime, int count) {
            PeriodTriggerValue conf;
            try {
                conf = (PeriodTriggerValue)Jsons.fromJson((String)triggerValue, PeriodTriggerValue.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid period config: " + triggerValue, e);
            }
            Assert.isTrue((conf != null && conf.verify() ? 1 : 0) != 0, () -> "Invalid period config: " + triggerValue);
            DatePeriods period = conf.getPeriod();
            Date start = conf.getStart();
            ArrayList<Date> result = new ArrayList<Date>(count);
            Date next = start.after(startTime) ? start : period.next(start, startTime, conf.getStep(), 1).begin();
            result.add(next);
            while (--count > 0) {
                next = period.next(next, conf.getStep(), 1).begin();
                result.add(next);
            }
            return result;
        }
    }
    ,
    FIXED_RATE(4, "60", "\u56fa\u5b9a\u9891\u7387(\u79d2)"){

        @Override
        public boolean validate0(String triggerValue) {
            return Long.parseLong(triggerValue) > 0L;
        }

        @Override
        public Date computeNextTriggerTime(String triggerValue, Date lastTriggerTime) {
            return this.computeNextTriggerTimes(triggerValue, lastTriggerTime, 1).get(0);
        }

        @Override
        public List<Date> computeNextTriggerTimes(String triggerValue, Date lastTriggerTime, int count) {
            long period = Long.parseLong(triggerValue);
            Assert.isTrue((period > 0L ? 1 : 0) != 0, () -> this.name() + " invalid trigger value: " + triggerValue);
            ArrayList<Date> result = new ArrayList<Date>(count);
            for (int i = 0; i < count; ++i) {
                lastTriggerTime = Dates.plusSeconds((Date)lastTriggerTime, (long)period);
                result.add(lastTriggerTime);
            }
            return result;
        }
    }
    ,
    FIXED_DELAY(5, "60", "\u56fa\u5b9a\u5ef6\u65f6(\u79d2)"){

        @Override
        public boolean validate0(String triggerValue) {
            return Long.parseLong(triggerValue) > 0L;
        }

        @Override
        public Date computeNextTriggerTime(String triggerValue, Date previousCompletedTime) {
            long delay = Long.parseLong(triggerValue);
            Assert.isTrue((delay > 0L ? 1 : 0) != 0, () -> this.name() + " invalid trigger value: " + triggerValue);
            return Dates.plusSeconds((Date)previousCompletedTime, (long)delay);
        }

        @Override
        public List<Date> computeNextTriggerTimes(String triggerValue, Date lastCompletedTime, int count) {
            Assert.isTrue((count == 1 ? 1 : 0) != 0, () -> this.name() + " unsupported compute multiple next trigger time: " + count);
            return Collections.singletonList(this.computeNextTriggerTime(triggerValue, lastCompletedTime));
        }
    }
    ,
    DEPEND(6, "1003164910267351000,1003164910267351001", "\u4efb\u52a1\u4f9d\u8d56"){

        @Override
        public boolean validate0(String triggerValue) {
            try {
                return !SchedDepend.parseTriggerValue(triggerValue).isEmpty();
            }
            catch (NumberFormatException ignored) {
                return false;
            }
        }

        @Override
        public Date computeNextTriggerTime(String triggerValue, Date startTime) {
            throw new UnsupportedOperationException(this.name() + " unsupported compute one next trigger time.");
        }

        @Override
        public List<Date> computeNextTriggerTimes(String triggerValue, Date startTime, int count) {
            throw new UnsupportedOperationException(this.name() + " unsupported compute multiple next trigger time.");
        }
    };

    private final int value;
    private final String example;
    private final String desc;

    private TriggerType(int value, String example, String desc) {
        this.value = value;
        this.example = example;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public String example() {
        return this.example;
    }

    public final boolean validate(String triggerValue) {
        return StringUtils.isNotBlank((CharSequence)triggerValue) && this.validate0(triggerValue);
    }

    protected abstract boolean validate0(String var1);

    public abstract Date computeNextTriggerTime(String var1, Date var2);

    public abstract List<Date> computeNextTriggerTimes(String var1, Date var2, int var3);

    public static TriggerType of(Integer value) {
        return (TriggerType)((Object)Objects.requireNonNull(Const.MAPPING.get(value), () -> "Invalid trigger type value: " + value));
    }

    public static final class Const {
        private static final Map<Integer, TriggerType> MAPPING = Enums.toMap(TriggerType.class, TriggerType::value);
        public static final List<TriggerType> FIXED_TYPES = ImmutableList.of((Object)((Object)FIXED_RATE), (Object)((Object)FIXED_DELAY));
    }
}

