/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.model;

import cn.ponfee.disjob.common.dag.DAGEdge;
import cn.ponfee.disjob.common.model.BaseEntity;
import cn.ponfee.disjob.core.enums.RunState;
import java.beans.Transient;

public class SchedWorkflow
extends BaseEntity {
    private static final long serialVersionUID = 3485414559751420216L;
    private Long wnstanceId;
    private String preNode;
    private String curNode;
    private Integer runState;
    private Long instanceId;

    public SchedWorkflow(Long wnstanceId, String preNode, String curNode) {
        this.wnstanceId = wnstanceId;
        this.preNode = preNode;
        this.curNode = curNode;
        this.runState = RunState.WAITING.value();
    }

    public DAGEdge toEdge() {
        return DAGEdge.of((String)this.preNode, (String)this.curNode);
    }

    @Transient
    public boolean isTerminal() {
        return RunState.of(this.runState).isTerminal();
    }

    @Transient
    public boolean isFailure() {
        return RunState.of(this.runState).isFailure();
    }

    @Transient
    public boolean isRunning() {
        return RunState.RUNNING.equalsValue(this.runState);
    }

    @Transient
    public boolean isWaiting() {
        return RunState.WAITING.equalsValue(this.runState);
    }

    @Transient
    public boolean isPaused() {
        return RunState.PAUSED.equalsValue(this.runState);
    }

    public Long getWnstanceId() {
        return this.wnstanceId;
    }

    public String getPreNode() {
        return this.preNode;
    }

    public String getCurNode() {
        return this.curNode;
    }

    public Integer getRunState() {
        return this.runState;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public void setWnstanceId(Long wnstanceId) {
        this.wnstanceId = wnstanceId;
    }

    public void setPreNode(String preNode) {
        this.preNode = preNode;
    }

    public void setCurNode(String curNode) {
        this.curNode = curNode;
    }

    public void setRunState(Integer runState) {
        this.runState = runState;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public SchedWorkflow() {
    }
}

