/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.dag;

import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.core.dag.PredecessorTask;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.core.model.SchedWorkflow;
import java.io.Serializable;
import java.util.List;

public class PredecessorInstance
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = 422243686633743869L;
    private long instanceId;
    private String curNode;
    private List<PredecessorTask> tasks;

    public static PredecessorInstance of(SchedWorkflow workflow, List<SchedTask> tasks) {
        PredecessorInstance instance = new PredecessorInstance();
        instance.setInstanceId(workflow.getInstanceId());
        instance.setCurNode(workflow.getCurNode());
        instance.setTasks(Collects.convert(tasks, PredecessorInstance::convert));
        return instance;
    }

    private static PredecessorTask convert(SchedTask source) {
        PredecessorTask target = new PredecessorTask();
        target.setTaskId(source.getTaskId());
        target.setTaskNo(source.getTaskNo());
        target.setTaskCount(source.getTaskCount());
        target.setExecuteSnapshot(source.getExecuteSnapshot());
        return target;
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public String getCurNode() {
        return this.curNode;
    }

    public List<PredecessorTask> getTasks() {
        return this.tasks;
    }

    public void setInstanceId(long instanceId) {
        this.instanceId = instanceId;
    }

    public void setCurNode(String curNode) {
        this.curNode = curNode;
    }

    public void setTasks(List<PredecessorTask> tasks) {
        this.tasks = tasks;
    }
}

