/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.dto.worker;

import cn.ponfee.disjob.core.dag.PredecessorInstance;
import cn.ponfee.disjob.core.dto.worker.AuthenticationParam;
import cn.ponfee.disjob.core.enums.JobType;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;
import java.util.List;
import org.springframework.util.Assert;

public class SplitJobParam
extends AuthenticationParam {
    private static final long serialVersionUID = -216622646271234535L;
    private String group;
    private String jobExecutor;
    private String jobParam;
    private JobType jobType;
    private RouteStrategy routeStrategy;
    private Integer broadcastWorkerCount;
    private List<PredecessorInstance> predecessorInstances;

    public static SplitJobParam of(SchedJob job) {
        Assert.isTrue((boolean)JobType.GENERAL.equalsValue(job.getJobType()), (String)"Job must be general.");
        return SplitJobParam.of(job, job.getJobExecutor(), null);
    }

    public static SplitJobParam of(SchedJob job, SchedInstance instance, List<PredecessorInstance> predecessorInstances) {
        Assert.isTrue((boolean)JobType.WORKFLOW.equalsValue(job.getJobType()), (String)"Job must be workflow.");
        Assert.isTrue((boolean)instance.isWorkflowNode(), () -> "Split job must be node instance: " + instance.getInstanceId());
        return SplitJobParam.of(job, instance.parseAttach().parseCurNode().getName(), predecessorInstances);
    }

    private static SplitJobParam of(SchedJob job, String jobExecutor, List<PredecessorInstance> predecessorInstances) {
        SplitJobParam param = new SplitJobParam();
        param.setGroup(job.getGroup());
        param.setJobExecutor(jobExecutor);
        param.setJobParam(job.getJobParam());
        param.setJobType(JobType.of(job.getJobType()));
        param.setRouteStrategy(RouteStrategy.of(job.getRouteStrategy()));
        param.setPredecessorInstances(predecessorInstances);
        return param;
    }

    public String getGroup() {
        return this.group;
    }

    public String getJobExecutor() {
        return this.jobExecutor;
    }

    public String getJobParam() {
        return this.jobParam;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public RouteStrategy getRouteStrategy() {
        return this.routeStrategy;
    }

    public Integer getBroadcastWorkerCount() {
        return this.broadcastWorkerCount;
    }

    public List<PredecessorInstance> getPredecessorInstances() {
        return this.predecessorInstances;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setJobExecutor(String jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    public void setJobParam(String jobParam) {
        this.jobParam = jobParam;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public void setRouteStrategy(RouteStrategy routeStrategy) {
        this.routeStrategy = routeStrategy;
    }

    public void setBroadcastWorkerCount(Integer broadcastWorkerCount) {
        this.broadcastWorkerCount = broadcastWorkerCount;
    }

    public void setPredecessorInstances(List<PredecessorInstance> predecessorInstances) {
        this.predecessorInstances = predecessorInstances;
    }
}

