/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.util.Enums;
import cn.ponfee.disjob.core.enums.RunState;
import java.util.Map;
import java.util.Objects;

public enum ExecuteState implements IntValueEnum<ExecuteState>
{
    WAITING(10, RunState.WAITING, "\u7b49\u5f85\u6267\u884c"),
    EXECUTING(20, RunState.RUNNING, "\u6b63\u5728\u6267\u884c"),
    PAUSED(30, RunState.PAUSED, "\u6682\u505c\u6267\u884c"),
    COMPLETED(40, RunState.COMPLETED, "\u6267\u884c\u5b8c\u6210"),
    DISPATCH_FAILED(50, RunState.CANCELED, "\u6d3e\u53d1\u5931\u8d25"),
    INITIALIZE_FAILED(51, RunState.CANCELED, "\u521d\u59cb\u5316\u5931\u8d25"),
    EXECUTE_FAILED(52, RunState.CANCELED, "\u6267\u884c\u5931\u8d25"),
    EXECUTE_EXCEPTION(53, RunState.CANCELED, "\u6267\u884c\u5f02\u5e38"),
    EXECUTE_TIMEOUT(54, RunState.CANCELED, "\u6267\u884c\u8d85\u65f6"),
    EXECUTE_COLLIDED(55, RunState.CANCELED, "\u6267\u884c\u51b2\u7a81"),
    BROADCAST_ABORTED(56, RunState.CANCELED, "\u5e7f\u64ad\u4efb\u52a1\u4e2d\u6b62"),
    MANUAL_CANCELED(57, RunState.CANCELED, "\u624b\u52a8\u53d6\u6d88"),
    SHUTDOWN_CANCELED(58, RunState.CANCELED, "Worker\u5173\u95ed\u53d6\u6d88");

    private final int value;
    private final RunState runState;
    private final String desc;
    private static final Map<Integer, ExecuteState> MAPPING;

    private ExecuteState(int value, RunState runState, String desc) {
        this.value = value;
        this.runState = runState;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public RunState runState() {
        return this.runState;
    }

    public boolean isPausable() {
        return this == WAITING || this == EXECUTING;
    }

    public boolean isTerminal() {
        return this.runState.isTerminal();
    }

    public boolean isFailure() {
        return this.runState.isFailure();
    }

    public static ExecuteState of(Integer value) {
        return Objects.requireNonNull(MAPPING.get(value), () -> "Invalid execute state value: " + value);
    }

    static {
        MAPPING = Enums.toMap(ExecuteState.class, ExecuteState::value);
    }
}

