/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.date.CronExpression;
import cn.ponfee.disjob.common.date.DatePeriods;
import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.core.model.PeriodTriggerValue;
import cn.ponfee.disjob.core.model.SchedDepend;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public enum TriggerType implements IntValueEnum<TriggerType>
{
    CRON(1, false, "0/10 * * * * ?", "Cron\u8868\u8fbe\u5f0f"){

        @Override
        protected boolean validate0(String triggerValue) {
            return CronExpression.isValidExpression((String)triggerValue);
        }

        @Override
        protected Date computeFirstTriggerTime0(String triggerValue, Date startTime) {
            return this.computeNextTriggerTime0(triggerValue, Dates.minusMillis((Date)startTime, (long)1L));
        }

        @Override
        protected Date computeNextTriggerTime0(String triggerValue, Date baseTime) {
            try {
                return new CronExpression(triggerValue).getNextValidTimeAfter(baseTime);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid cron expression: " + triggerValue, e);
            }
        }

        @Override
        protected List<Date> computeNextTriggerTimes0(String triggerValue, Date baseTime, int count) {
            try {
                CronExpression cronExpression = new CronExpression(triggerValue);
                ArrayList<Date> result = new ArrayList<Date>(count);
                while (count-- > 0 && (baseTime = cronExpression.getNextValidTimeAfter(baseTime)) != null) {
                    result.add(baseTime);
                }
                return result;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid cron expression: " + triggerValue, e);
            }
        }
    }
    ,
    ONCE(2, false, "2000-01-01 00:00:00", "\u6307\u5b9a\u65f6\u95f4"){

        @Override
        protected boolean validate0(String triggerValue) {
            try {
                Dates.DATETIME_FORMAT.parse(triggerValue);
                return true;
            }
            catch (Exception ignored) {
                return false;
            }
        }

        @Override
        protected Date computeFirstTriggerTime0(String triggerValue, Date startTime) {
            return this.computeNextTriggerTime0(triggerValue, Dates.minusMillis((Date)startTime, (long)1L));
        }

        @Override
        protected Date computeNextTriggerTime0(String triggerValue, Date baseTime) {
            try {
                Date next = Dates.DATETIME_FORMAT.parse(triggerValue);
                return next.after(baseTime) ? next : null;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid once date value: " + triggerValue, e);
            }
        }

        @Override
        protected List<Date> computeNextTriggerTimes0(String triggerValue, Date baseTime, int count) {
            Date next = this.computeNextTriggerTime0(triggerValue, baseTime);
            return next == null ? Collections.emptyList() : Collections.singletonList(next);
        }
    }
    ,
    PERIOD(3, false, "{\"period\":\"DAILY\", \"start\":\"2000-01-01 00:00:00\", \"step\":10}", "\u6307\u5b9a\u5468\u671f"){

        @Override
        protected boolean validate0(String triggerValue) {
            try {
                PeriodTriggerValue conf = (PeriodTriggerValue)Jsons.fromJson((String)triggerValue, PeriodTriggerValue.class);
                return conf != null && conf.verify();
            }
            catch (Exception ignored) {
                return false;
            }
        }

        @Override
        protected Date computeFirstTriggerTime0(String triggerValue, Date startTime) {
            return this.computeNextTriggerTime0(triggerValue, Dates.minusMillis((Date)startTime, (long)1L));
        }

        @Override
        protected Date computeNextTriggerTime0(String triggerValue, Date targetTime) {
            List<Date> list = this.computeNextTriggerTimes0(triggerValue, targetTime, 1);
            return list.isEmpty() ? null : list.get(0);
        }

        @Override
        protected List<Date> computeNextTriggerTimes0(String triggerValue, Date targetTime, int count) {
            PeriodTriggerValue conf;
            try {
                conf = (PeriodTriggerValue)Jsons.fromJson((String)triggerValue, PeriodTriggerValue.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid period config: " + triggerValue, e);
            }
            Assert.isTrue((conf != null && conf.verify() ? 1 : 0) != 0, () -> "Invalid period config: " + triggerValue);
            DatePeriods period = conf.getPeriod();
            Date start = conf.getStart();
            ArrayList<Date> result = new ArrayList<Date>(count);
            Date next = start.after(targetTime) ? start : period.next(start, targetTime, conf.getStep(), 1).begin();
            result.add(next);
            while (--count > 0) {
                next = period.next(next, conf.getStep(), 1).begin();
                result.add(next);
            }
            return result;
        }
    }
    ,
    INTERVAL(4, false, "60", "\u6307\u5b9a\u95f4\u9694(\u79d2)"){

        @Override
        protected boolean validate0(String triggerValue) {
            return Long.parseLong(triggerValue) > 0L;
        }

        @Override
        protected Date computeFirstTriggerTime0(String triggerValue, Date startTime) {
            return new Date(startTime.getTime());
        }

        @Override
        protected Date computeNextTriggerTime0(String triggerValue, Date lastTriggerTime) {
            return this.computeNextTriggerTimes0(triggerValue, lastTriggerTime, 1).get(0);
        }

        @Override
        protected List<Date> computeNextTriggerTimes0(String triggerValue, Date lastTriggerTime, int count) {
            long interval = Long.parseLong(triggerValue);
            Assert.isTrue((interval > 0L ? 1 : 0) != 0, () -> this.name() + " invalid trigger value: " + triggerValue);
            ArrayList<Date> result = new ArrayList<Date>(count);
            for (int i = 0; i < count; ++i) {
                lastTriggerTime = Dates.plusSeconds((Date)lastTriggerTime, (long)interval);
                result.add(lastTriggerTime);
            }
            return result;
        }
    }
    ,
    FIXED_RATE(5, true, "60", "\u56fa\u5b9a\u9891\u7387(\u79d2)"){

        @Override
        protected boolean validate0(String triggerValue) {
            return Long.parseLong(triggerValue) > 0L;
        }

        @Override
        protected Date computeFirstTriggerTime0(String triggerValue, Date startTime) {
            return new Date(startTime.getTime());
        }

        @Override
        protected Date computeNextTriggerTime0(String triggerValue, Date lastTriggerTime) {
            long rate = Long.parseLong(triggerValue);
            Assert.isTrue((rate > 0L ? 1 : 0) != 0, () -> this.name() + " invalid trigger value: " + triggerValue);
            return Dates.plusSeconds((Date)lastTriggerTime, (long)rate);
        }

        @Override
        protected List<Date> computeNextTriggerTimes0(String triggerValue, Date lastTriggerTime, int count) {
            throw new UnsupportedOperationException(this.name() + " unsupported compute multiple next trigger times.");
        }
    }
    ,
    FIXED_DELAY(6, true, "60", "\u56fa\u5b9a\u5ef6\u65f6(\u79d2)"){

        @Override
        protected boolean validate0(String triggerValue) {
            return Long.parseLong(triggerValue) > 0L;
        }

        @Override
        protected Date computeFirstTriggerTime0(String triggerValue, Date startTime) {
            return new Date(startTime.getTime());
        }

        @Override
        protected Date computeNextTriggerTime0(String triggerValue, Date lastCompletedTime) {
            long delay = Long.parseLong(triggerValue);
            Assert.isTrue((delay > 0L ? 1 : 0) != 0, () -> this.name() + " invalid trigger value: " + triggerValue);
            return Dates.plusSeconds((Date)lastCompletedTime, (long)delay);
        }

        @Override
        protected List<Date> computeNextTriggerTimes0(String triggerValue, Date lastCompletedTime, int count) {
            throw new UnsupportedOperationException(this.name() + " unsupported compute multiple next trigger times.");
        }
    }
    ,
    DEPEND(7, false, "1003164910267351000,1003164910267351001", "\u4efb\u52a1\u4f9d\u8d56"){

        @Override
        protected boolean validate0(String triggerValue) {
            try {
                return !SchedDepend.parseTriggerValue(triggerValue).isEmpty();
            }
            catch (NumberFormatException ignored) {
                return false;
            }
        }

        @Override
        protected Date computeFirstTriggerTime0(String triggerValue, Date startTime) {
            throw new UnsupportedOperationException(this.name() + " unsupported compute first trigger time.");
        }

        @Override
        protected Date computeNextTriggerTime0(String triggerValue, Date baseTime) {
            throw new UnsupportedOperationException(this.name() + " unsupported compute one next trigger time.");
        }

        @Override
        protected List<Date> computeNextTriggerTimes0(String triggerValue, Date baseTime, int count) {
            throw new UnsupportedOperationException(this.name() + " unsupported compute multiple next trigger times.");
        }
    };

    private final int value;
    private final boolean fixedTriggerType;
    private final String example;
    private final String desc;
    private static final TriggerType[] VALUES;

    private TriggerType(int value, boolean fixedTriggerType, String example, String desc) {
        this.value = value;
        this.fixedTriggerType = fixedTriggerType;
        this.example = example;
        this.desc = desc;
    }

    public final int value() {
        return this.value;
    }

    public final String desc() {
        return this.desc;
    }

    public final boolean isFixedTriggerType() {
        return this.fixedTriggerType;
    }

    public final String example() {
        return this.example;
    }

    protected abstract boolean validate0(String var1);

    protected abstract Date computeFirstTriggerTime0(String var1, Date var2);

    protected abstract Date computeNextTriggerTime0(String var1, Date var2);

    protected abstract List<Date> computeNextTriggerTimes0(String var1, Date var2, int var3);

    public final boolean validate(String triggerValue) {
        return StringUtils.isNotBlank((CharSequence)triggerValue) && this.validate0(triggerValue);
    }

    public final Date computeFirstTriggerTime(String triggerValue, Date date) {
        Assert.notNull((Object)date, (String)"Param date cannot be null.");
        return this.computeFirstTriggerTime0(triggerValue, date);
    }

    public final Date computeNextTriggerTime(String triggerValue, Date date) {
        Assert.notNull((Object)date, (String)"Param date cannot be null.");
        Date next = this.computeNextTriggerTime0(triggerValue, date);
        if (next == null || next.after(date)) {
            return next;
        }
        throw new IllegalStateException(this.name() + " invalid next after: " + triggerValue + ", " + Dates.format((Date)date));
    }

    public final List<Date> computeNextTriggerTimes(String triggerValue, Date date, int count) {
        Assert.notNull((Object)date, (String)"Param date cannot be null.");
        List<Date> list = this.computeNextTriggerTimes0(triggerValue, date, count);
        if (list.isEmpty()) {
            return list;
        }
        Date next = date;
        for (Date item : list) {
            Date curr = next;
            next = item;
            Assert.isTrue((boolean)next.after(curr), () -> this.name() + " invalid next after: " + triggerValue + ", " + Dates.format((Date)date));
        }
        return list;
    }

    public static TriggerType of(int value) {
        for (TriggerType e : VALUES) {
            if (e.value() != value) continue;
            return e;
        }
        throw new IllegalArgumentException("Invalid trigger type value: " + value);
    }

    static {
        VALUES = TriggerType.values();
    }
}

