/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.model;

import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.common.model.BaseEntity;
import cn.ponfee.disjob.core.enums.CollidedStrategy;
import cn.ponfee.disjob.core.enums.JobState;
import cn.ponfee.disjob.core.enums.MisfireStrategy;
import cn.ponfee.disjob.core.enums.RedeployStrategy;
import cn.ponfee.disjob.core.enums.RetryType;
import cn.ponfee.disjob.core.enums.RunState;
import cn.ponfee.disjob.core.enums.TriggerType;
import com.google.common.math.IntMath;
import java.beans.Transient;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class SchedJob
extends BaseEntity {
    private static final long serialVersionUID = -1595287180906247896L;
    private Long jobId;
    private String group;
    private String jobName;
    private Integer jobType;
    private Integer jobState;
    private String jobExecutor;
    private String jobParam;
    private Integer retryType;
    private Integer retryCount;
    private Integer retryInterval;
    private Date startTime;
    private Date endTime;
    private Integer triggerType;
    private String triggerValue;
    private Integer executeTimeout;
    private Integer collidedStrategy;
    private Integer misfireStrategy;
    private Integer routeStrategy;
    private Integer redeployStrategy;
    private Long lastTriggerTime;
    private Long nextTriggerTime;
    private Date nextScanTime;
    private Integer scanFailedCount;
    private String remark;
    private Integer version;
    private String updatedBy;
    private String createdBy;

    @Transient
    public boolean isEnabled() {
        return JobState.ENABLED.equalsValue(this.jobState);
    }

    @Transient
    public boolean isDisabled() {
        return JobState.DISABLED.equalsValue(this.jobState);
    }

    @Transient
    public boolean isFixedTriggerType() {
        return TriggerType.of(this.triggerType).isFixedTriggerType();
    }

    public Long obtainNextTriggerTime() {
        if (this.nextTriggerTime == null || this.endTime == null) {
            return this.nextTriggerTime;
        }
        return this.nextTriggerTime > this.endTime.getTime() ? null : this.nextTriggerTime;
    }

    public void verifyForAdd(int maximumJobRetryCount) {
        this.verifyAndDefaultSetting(maximumJobRetryCount);
    }

    public void verifyForUpdate(int maximumJobRetryCount) {
        Assert.isTrue((this.jobId != null && this.jobId > 0L ? 1 : 0) != 0, () -> "Invalid jobId: " + this.jobId);
        Assert.isTrue((this.version != null && this.version > 0 ? 1 : 0) != 0, () -> "Invalid version: " + this.version);
        this.verifyAndDefaultSetting(maximumJobRetryCount);
    }

    public boolean requiredUpdateExecutor() {
        if (this.jobExecutor == null) {
            Assert.isNull((Object)this.jobParam, (String)"Job param must be null when not set job executor.");
            Assert.isNull((Object)this.jobType, (String)"Job type must be null when not set job executor.");
            Assert.isNull((Object)this.routeStrategy, (String)"Route strategy must be null when not set job executor.");
            return false;
        }
        return true;
    }

    public boolean requiredUpdateTrigger(Integer curTriggerType, String curTriggerValue) {
        if (this.triggerType == null) {
            Assert.isNull((Object)this.triggerValue, (String)"Trigger value must be null when not set trigger type.");
            return false;
        }
        if (Objects.equals(this.triggerType, curTriggerType) && Objects.equals(this.triggerValue, curTriggerValue)) {
            this.triggerType = null;
            this.triggerValue = null;
            return false;
        }
        return true;
    }

    public int incrementAndGetScanFailedCount() {
        SchedJob schedJob = this;
        schedJob.scanFailedCount = schedJob.scanFailedCount + 1;
        return schedJob.scanFailedCount;
    }

    public boolean retryable(RunState runState, int retriedCount) {
        Assert.state((boolean)runState.isTerminal(), (String)"Run state must be terminated.");
        if (!runState.isFailure()) {
            return false;
        }
        return !RetryType.NONE.equalsValue(this.retryType) && retriedCount < this.retryCount;
    }

    public long computeRetryTriggerTime(int failCount) {
        Assert.isTrue((!RetryType.NONE.equalsValue(this.retryType) ? 1 : 0) != 0, () -> "Sched job '" + this.jobId + "' retry type is NONE.");
        Assert.isTrue((this.retryCount > 0 ? 1 : 0) != 0, () -> "Sched job '" + this.jobId + "' retry count must greater than 0, but actual " + this.retryCount);
        Assert.isTrue((failCount <= this.retryCount ? 1 : 0) != 0, () -> "Sched job '" + this.jobId + "' retried " + failCount + " exceed " + this.retryCount + " limit.");
        return System.currentTimeMillis() + (long)this.retryInterval.intValue() * (long)IntMath.pow((int)failCount, (int)2);
    }

    private void verifyAndDefaultSetting(int maximumJobRetryCount) {
        Assert.hasText((String)this.group, (String)"Group cannot be blank.");
        this.group = this.group.trim();
        Assert.isTrue((this.group.length() <= 60 ? 1 : 0) != 0, (String)"Group length cannot exceed 60.");
        Assert.hasText((String)this.jobName, (String)"jobName cannot be blank.");
        this.jobName = this.jobName.trim();
        Assert.isTrue((this.jobName.length() <= 60 ? 1 : 0) != 0, (String)"jobName length cannot exceed 60.");
        this.remark = StringUtils.trim((String)this.remark);
        Assert.isTrue((StringUtils.length((CharSequence)this.remark) <= 255 ? 1 : 0) != 0, (String)"remark length cannot exceed 255.");
        this.jobState = (Integer)ObjectUtils.defaultIfNull((Object)this.jobState, (Object)JobState.DISABLED.value());
        this.retryType = (Integer)ObjectUtils.defaultIfNull((Object)this.retryType, (Object)RetryType.NONE.value());
        this.executeTimeout = (Integer)ObjectUtils.defaultIfNull((Object)this.executeTimeout, (Object)0);
        this.collidedStrategy = (Integer)ObjectUtils.defaultIfNull((Object)this.collidedStrategy, (Object)CollidedStrategy.CONCURRENT.value());
        this.misfireStrategy = (Integer)ObjectUtils.defaultIfNull((Object)this.misfireStrategy, (Object)MisfireStrategy.FIRE_ONCE_NOW.value());
        this.redeployStrategy = (Integer)ObjectUtils.defaultIfNull((Object)this.redeployStrategy, (Object)RedeployStrategy.RESUME.value());
        this.triggerValue = StringUtils.trim((String)this.triggerValue);
        JobState.of(this.jobState);
        Assert.isTrue((this.executeTimeout >= 0 ? 1 : 0) != 0, () -> "Invalid execute timeout: " + this.executeTimeout);
        CollidedStrategy.of(this.collidedStrategy);
        MisfireStrategy.of(this.misfireStrategy);
        RedeployStrategy.of(this.redeployStrategy);
        if (RetryType.of(this.retryType) == RetryType.NONE) {
            this.retryCount = (Integer)ObjectUtils.defaultIfNull((Object)this.retryCount, (Object)0);
            this.retryInterval = (Integer)ObjectUtils.defaultIfNull((Object)this.retryInterval, (Object)0);
            Assert.isTrue((this.retryCount == 0 ? 1 : 0) != 0, (String)"Retry count cannot set value.");
            Assert.isTrue((this.retryInterval == 0 ? 1 : 0) != 0, (String)"Retry interval cannot set value.");
        } else {
            boolean verify = this.retryCount != null && 0 < this.retryCount && this.retryCount <= maximumJobRetryCount;
            Assert.isTrue((boolean)verify, () -> "Retry count must be range [1, " + maximumJobRetryCount + "]");
            Assert.isTrue((this.retryInterval != null && this.retryInterval > 0 ? 1 : 0) != 0, (String)"Retry interval must greater than 0.");
        }
        if (this.startTime != null && this.endTime != null && this.startTime.after(this.endTime)) {
            throw new IllegalArgumentException("Invalid time range: [" + Dates.format((Date)this.startTime) + " ~ " + Dates.format((Date)this.endTime) + "]");
        }
    }

    public Long getJobId() {
        return this.jobId;
    }

    public String getGroup() {
        return this.group;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Integer getJobType() {
        return this.jobType;
    }

    public Integer getJobState() {
        return this.jobState;
    }

    public String getJobExecutor() {
        return this.jobExecutor;
    }

    public String getJobParam() {
        return this.jobParam;
    }

    public Integer getRetryType() {
        return this.retryType;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public Integer getRetryInterval() {
        return this.retryInterval;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Integer getTriggerType() {
        return this.triggerType;
    }

    public String getTriggerValue() {
        return this.triggerValue;
    }

    public Integer getExecuteTimeout() {
        return this.executeTimeout;
    }

    public Integer getCollidedStrategy() {
        return this.collidedStrategy;
    }

    public Integer getMisfireStrategy() {
        return this.misfireStrategy;
    }

    public Integer getRouteStrategy() {
        return this.routeStrategy;
    }

    public Integer getRedeployStrategy() {
        return this.redeployStrategy;
    }

    public Long getLastTriggerTime() {
        return this.lastTriggerTime;
    }

    public Long getNextTriggerTime() {
        return this.nextTriggerTime;
    }

    public Date getNextScanTime() {
        return this.nextScanTime;
    }

    public Integer getScanFailedCount() {
        return this.scanFailedCount;
    }

    public String getRemark() {
        return this.remark;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setJobType(Integer jobType) {
        this.jobType = jobType;
    }

    public void setJobState(Integer jobState) {
        this.jobState = jobState;
    }

    public void setJobExecutor(String jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    public void setJobParam(String jobParam) {
        this.jobParam = jobParam;
    }

    public void setRetryType(Integer retryType) {
        this.retryType = retryType;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    public void setRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setTriggerType(Integer triggerType) {
        this.triggerType = triggerType;
    }

    public void setTriggerValue(String triggerValue) {
        this.triggerValue = triggerValue;
    }

    public void setExecuteTimeout(Integer executeTimeout) {
        this.executeTimeout = executeTimeout;
    }

    public void setCollidedStrategy(Integer collidedStrategy) {
        this.collidedStrategy = collidedStrategy;
    }

    public void setMisfireStrategy(Integer misfireStrategy) {
        this.misfireStrategy = misfireStrategy;
    }

    public void setRouteStrategy(Integer routeStrategy) {
        this.routeStrategy = routeStrategy;
    }

    public void setRedeployStrategy(Integer redeployStrategy) {
        this.redeployStrategy = redeployStrategy;
    }

    public void setLastTriggerTime(Long lastTriggerTime) {
        this.lastTriggerTime = lastTriggerTime;
    }

    public void setNextTriggerTime(Long nextTriggerTime) {
        this.nextTriggerTime = nextTriggerTime;
    }

    public void setNextScanTime(Date nextScanTime) {
        this.nextScanTime = nextScanTime;
    }

    public void setScanFailedCount(Integer scanFailedCount) {
        this.scanFailedCount = scanFailedCount;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }
}

