/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.util;

import cn.ponfee.disjob.common.concurrent.ThreadPoolExecutors;
import cn.ponfee.disjob.common.concurrent.Threads;
import cn.ponfee.disjob.common.exception.Throwables;
import cn.ponfee.disjob.common.spring.SpringContextHolder;
import cn.ponfee.disjob.common.util.NetUtils;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisjobUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DisjobUtils.class);
    public static final Interner<Long> INSTANCE_LOCK_POOL = Interners.newWeakInterner();

    public static String getLocalHost() {
        return DisjobUtils.getLocalHost(SpringContextHolder.getProperty((String)"disjob.bound.server.host"));
    }

    public static String getLocalHost(String specifiedHost) {
        String host = specifiedHost;
        if (DisjobUtils.isValidHost(host, "specified")) {
            return host;
        }
        host = System.getProperty("disjob.bound.server.host");
        if (DisjobUtils.isValidHost(host, "System#getProperty")) {
            return host;
        }
        host = System.getenv("disjob.bound.server.host");
        if (DisjobUtils.isValidHost(host, "System#getenv")) {
            return host;
        }
        host = NetUtils.getLocalHost();
        if (DisjobUtils.isValidHost(host, "NetUtils#getLocalHost")) {
            return host;
        }
        throw new Error("Not found available server host.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R doInSynchronized(Long lock, Throwables.ThrowingSupplier<R, ?> action) throws Throwable {
        Long l = (Long)INSTANCE_LOCK_POOL.intern((Object)lock);
        synchronized (l) {
            return (R)action.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doInSynchronized(Long lock, Throwables.ThrowingRunnable<?> action, Supplier<String> message) {
        Throwable t = null;
        try {
            DisjobUtils.doInSynchronized(lock, action);
        }
        catch (Throwable e) {
            t = e;
            LOG.error(message.get(), t);
        }
        finally {
            if (DisjobUtils.isCurrentThreadInterrupted(t)) {
                boolean interrupted = Thread.currentThread().isInterrupted();
                LOG.info("Do synchronized retry interrupted {}, {}", (Object)interrupted, (Object)message.get());
                ThreadPoolExecutors.commonThreadPool().execute(() -> {
                    try {
                        DisjobUtils.doInSynchronized(lock, action);
                    }
                    catch (Throwable e) {
                        LOG.error("Do synchronized retry error, " + (String)message.get(), e);
                    }
                });
            }
            Threads.interruptIfNecessary((Throwable)t);
        }
    }

    public static void checkClobMaximumLength(String text, String name) {
        int length = StringUtils.length((CharSequence)text);
        if (length > 65535) {
            throw new IllegalArgumentException(name + " length too large: " + length);
        }
    }

    private static boolean isValidHost(String host, String from) {
        if (StringUtils.isBlank((CharSequence)host)) {
            return false;
        }
        if (!NetUtils.isValidLocalHost((String)host)) {
            LOG.warn("Invalid server host configured {}: {}", (Object)from, (Object)host);
            return false;
        }
        if (!NetUtils.isReachableHost((String)host)) {
            LOG.warn("Unreachable server host configured {}: {}", (Object)from, (Object)host);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doInSynchronized(Long lock, Throwables.ThrowingRunnable<?> action) throws Throwable {
        Long l = (Long)INSTANCE_LOCK_POOL.intern((Object)lock);
        synchronized (l) {
            action.run();
        }
    }

    private static boolean isCurrentThreadInterrupted(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof ThreadDeath || t instanceof InterruptedException) {
            return true;
        }
        Thread curThread = Thread.currentThread();
        return curThread.isInterrupted() || Threads.isStopped((Thread)curThread);
    }
}

