/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.core.enums.ExecuteState;

public enum Operation {
    TRIGGER(ExecuteState.WAITING, ExecuteState.EXECUTING),
    PAUSE(ExecuteState.EXECUTING, ExecuteState.PAUSED),
    EXCEPTION_CANCEL(ExecuteState.EXECUTING, ExecuteState.EXECUTE_EXCEPTION),
    COLLIDED_CANCEL(ExecuteState.EXECUTING, ExecuteState.EXECUTE_COLLIDED),
    SHUTDOWN_RESUME(ExecuteState.EXECUTING, ExecuteState.WAITING),
    SHUTDOWN_PAUSE(ExecuteState.EXECUTING, ExecuteState.PAUSED),
    SHUTDOWN_CANCEL(ExecuteState.EXECUTING, ExecuteState.SHUTDOWN_CANCELED),
    MANUAL_CANCEL(ExecuteState.EXECUTING, ExecuteState.MANUAL_CANCELED);

    private final ExecuteState fromState;
    private final ExecuteState toState;

    private Operation(ExecuteState fromState, ExecuteState toState) {
        this.fromState = fromState;
        this.toState = toState;
    }

    public ExecuteState fromState() {
        return this.fromState;
    }

    public ExecuteState toState() {
        return this.toState;
    }

    public boolean isTrigger() {
        return this == TRIGGER;
    }

    public boolean isNotTrigger() {
        return !this.isTrigger();
    }
}

