/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;

public enum RouteStrategy implements IntValueEnum<RouteStrategy>
{
    ROUND_ROBIN(1, "\u8f6e\u8be2"),
    RANDOM(2, "\u968f\u673a"),
    SIMPLE_HASH(3, "\u7b80\u5355\u54c8\u5e0c"),
    CONSISTENT_HASH(4, "\u4e00\u81f4\u6027\u54c8\u5e0c"),
    LOCAL_PRIORITY(5, "\u672c\u5730\u4f18\u5148"),
    BROADCAST(6, "\u5e7f\u64ad");

    private final int value;
    private final String desc;
    private static final RouteStrategy[] VALUES;

    private RouteStrategy(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public boolean isBroadcast() {
        return this == BROADCAST;
    }

    public boolean isNotBroadcast() {
        return !this.isBroadcast();
    }

    public boolean isRoundRobin() {
        return this == ROUND_ROBIN;
    }

    public boolean isNotRoundRobin() {
        return !this.isRoundRobin();
    }

    public static RouteStrategy of(int value) {
        for (RouteStrategy e : VALUES) {
            if (e.value() != value) continue;
            return e;
        }
        throw new IllegalArgumentException("Invalid route strategy value: " + value);
    }

    static {
        VALUES = RouteStrategy.values();
    }
}

