/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;

public enum RunState implements IntValueEnum<RunState>
{
    WAITING(10, false, false, "\u5f85\u8fd0\u884c"),
    RUNNING(20, false, false, "\u8fd0\u884c\u4e2d"),
    PAUSED(30, false, false, "\u5df2\u6682\u505c"),
    COMPLETED(40, true, false, "\u5df2\u5b8c\u6210"),
    CANCELED(50, true, true, "\u5df2\u53d6\u6d88");

    private final int value;
    private final boolean terminal;
    private final boolean failure;
    private final String desc;
    private static final RunState[] VALUES;

    private RunState(int value, boolean terminal, boolean failure, String desc) {
        this.value = value;
        this.terminal = terminal;
        this.failure = failure;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public boolean isPausable() {
        return this == WAITING || this == RUNNING;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public boolean isFailure() {
        return this.failure;
    }

    public static RunState of(int value) {
        for (RunState e : VALUES) {
            if (e.value() != value) continue;
            return e;
        }
        throw new IllegalArgumentException("Invalid run state value: " + value);
    }

    static {
        VALUES = RunState.values();
    }
}

