/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.exception.BaseException;
import cn.ponfee.disjob.common.exception.BaseRuntimeException;
import cn.ponfee.disjob.common.model.Result;
import cn.ponfee.disjob.core.base.JobCodeMsg;
import cn.ponfee.disjob.core.exception.AuthenticationException;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.HandlerMethod;

@ConditionalOnMissingClass(value={"cn.ponfee.disjob.core.base.ControllerExceptionHandler"})
@RestControllerAdvice(basePackages={"cn.ponfee.disjob.supervisor", "cn.ponfee.disjob.worker"})
class ControllerExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ControllerExceptionHandler.class);
    private static final List<Class<? extends Exception>> BIZ_EXCEPTIONS = ImmutableList.of(IllegalArgumentException.class, IllegalStateException.class, UnsupportedOperationException.class, BaseException.class, BaseRuntimeException.class);

    ControllerExceptionHandler() {
    }

    @ExceptionHandler(value={Throwable.class})
    public void execute(HandlerMethod handlerMethod, HttpServletResponse response, Throwable t) throws IOException {
        String errorMsg = ExceptionUtils.getRootCauseMessage((Throwable)t);
        if (BIZ_EXCEPTIONS.stream().anyMatch(e -> e.isInstance(t))) {
            LOG.error("Handle biz exception {}: {}", (Object)t.getClass().getName(), (Object)errorMsg);
        } else {
            LOG.error("Handle server exception", t);
        }
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        if (ControllerExceptionHandler.isMethodReturnResultType(handlerMethod)) {
            response.setContentType("application/json;charset=UTF-8");
            errorMsg = Result.failure((int)JobCodeMsg.SERVER_ERROR.getCode(), (String)errorMsg).toJson();
        } else {
            response.setContentType("text/plain;charset=UTF-8");
            response.setStatus(this.obtainHttpStatus(t).value());
        }
        out.write(errorMsg);
        out.flush();
    }

    private HttpStatus obtainHttpStatus(Throwable t) {
        if (t instanceof AuthenticationException) {
            return HttpStatus.UNAUTHORIZED;
        }
        if (t instanceof IllegalArgumentException) {
            return HttpStatus.BAD_REQUEST;
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    private static boolean isMethodReturnResultType(HandlerMethod handlerMethod) {
        if (handlerMethod == null || handlerMethod.getBeanType() == BasicErrorController.class) {
            return false;
        }
        return Result.class.isAssignableFrom(handlerMethod.getMethod().getReturnType());
    }
}

