/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.core.base.GroupInfoService;
import cn.ponfee.disjob.core.base.Server;
import cn.ponfee.disjob.core.base.Tokens;
import cn.ponfee.disjob.core.enums.TokenType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Objects;
import org.springframework.util.Assert;

@JsonSerialize(using=JacksonSerializer.class)
@JsonDeserialize(using=JacksonDeserializer.class)
public class Supervisor
extends Server
implements Comparable<Supervisor> {
    private static final long serialVersionUID = -1254559108807415145L;
    private final transient String serializedValue;

    public Supervisor(String host, int port) {
        super(host, port);
        this.serializedValue = this.host + ":" + this.port;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Supervisor && super.equals(obj);
    }

    @Override
    public int compareTo(Supervisor that) {
        int n = this.host.compareTo(that.host);
        if (n != 0) {
            return n;
        }
        return Integer.compare(this.port, that.port);
    }

    @Override
    public final String serialize() {
        return this.serializedValue;
    }

    public static Supervisor deserialize(String text) {
        String[] array = text.split(":", 2);
        Assert.isTrue((array.length == 2 ? 1 : 0) != 0, () -> "Invalid supervisor value: " + text);
        return new Supervisor(array[0], Integer.parseInt(array[1]));
    }

    public static Local local() {
        return Local.instance;
    }

    static class JacksonDeserializer
    extends JsonDeserializer<Supervisor> {
        JacksonDeserializer() {
        }

        public Supervisor deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
            return Supervisor.deserialize(p.getText());
        }
    }

    static class JacksonSerializer
    extends JsonSerializer<Supervisor> {
        JacksonSerializer() {
        }

        public void serialize(Supervisor value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            if (value == null) {
                generator.writeNull();
            } else {
                generator.writeString(value.serialize());
            }
        }
    }

    public static abstract class Local
    extends Supervisor {
        private static volatile Local instance = null;
        private final LocalDateTime startupTime;

        private Local(String host, int port) {
            super(host, port);
            SingletonClassConstraint.constrain(Local.class);
            this.startupTime = LocalDateTime.now();
        }

        public final LocalDateTime getStartupTime() {
            return this.startupTime;
        }

        public abstract String getWorkerContextPath(String var1);

        public abstract String createSupervisorAuthenticationToken(String var1);

        public abstract boolean verifyWorkerAuthenticationToken(String var1, String var2);

        public abstract boolean verifyUserAuthenticationToken(String var1, String var2);

        public abstract boolean verifyWorkerSignatureToken(String var1, String var2);

        private static synchronized Local create(String host, int port, final GroupInfoService groupInfoService) {
            if (instance != null) {
                throw new Error("Local supervisor already created.");
            }
            instance = new Local(host, port){

                @Override
                public String getWorkerContextPath(String group) {
                    return groupInfoService.getWorkerContextPath(group);
                }

                @Override
                public String createSupervisorAuthenticationToken(String group) {
                    String supervisorToken = groupInfoService.getSupervisorToken(group);
                    return Tokens.createAuthentication(supervisorToken, TokenType.supervisor, group);
                }

                @Override
                public boolean verifyWorkerAuthenticationToken(String group, String workerAuthenticationToken) {
                    String workerToken = groupInfoService.getWorkerToken(group);
                    return Tokens.verifyAuthentication(workerAuthenticationToken, workerToken, TokenType.worker, group);
                }

                @Override
                public boolean verifyUserAuthenticationToken(String group, String userAuthenticationToken) {
                    String userToken = groupInfoService.getUserToken(group);
                    return Tokens.verifyAuthentication(userAuthenticationToken, userToken, TokenType.user, group);
                }

                @Override
                public boolean verifyWorkerSignatureToken(String group, String workerSignatureToken) {
                    String workerToken = groupInfoService.getWorkerToken(group);
                    return Tokens.verifySignature(workerSignatureToken, workerToken, TokenType.worker, group);
                }
            };
            return instance;
        }
    }
}

