/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.dto.supervisor;

import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.core.enums.ExecuteState;
import cn.ponfee.disjob.core.enums.Operation;
import java.io.Serializable;
import org.springframework.util.Assert;

public class StopTaskParam
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = 7700836087189718161L;
    private Long wnstanceId;
    private long instanceId;
    private long taskId;
    private Operation operation;
    private ExecuteState toState;
    private String errorMsg;
    private String worker;

    public static StopTaskParam of(Long wnstanceId, long instanceId, long taskId, String worker, Operation operation, ExecuteState toState, String errorMsg) {
        StopTaskParam param = new StopTaskParam();
        param.setWnstanceId(wnstanceId);
        param.setInstanceId(instanceId);
        param.setTaskId(taskId);
        param.setWorker(worker);
        param.setOperation(operation);
        param.setToState(toState);
        param.setErrorMsg(errorMsg);
        param.check();
        return param;
    }

    public void check() {
        Assert.hasText((String)this.worker, (String)"Stop task worker cannot be blank.");
        Assert.notNull((Object)((Object)this.operation), (String)"Stop task operation cannot be null.");
        Assert.notNull((Object)((Object)this.toState), (String)"Stop task target state cannot be null.");
        Assert.isTrue((this.toState != ExecuteState.EXECUTING ? 1 : 0) != 0, (String)"Stop task target state cannot be EXECUTING.");
    }

    public Long getWnstanceId() {
        return this.wnstanceId;
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public ExecuteState getToState() {
        return this.toState;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getWorker() {
        return this.worker;
    }

    public void setWnstanceId(Long wnstanceId) {
        this.wnstanceId = wnstanceId;
    }

    public void setInstanceId(long instanceId) {
        this.instanceId = instanceId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public void setToState(ExecuteState toState) {
        this.toState = toState;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void setWorker(String worker) {
        this.worker = worker;
    }
}

