/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.alert;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.util.Enums;
import java.util.Arrays;

public enum AlertType implements IntValueEnum<AlertType>
{
    ALARM(1, "\u8b66\u62a5"),
    NOTICE(2, "\u901a\u77e5");

    private final int value;
    private final String desc;
    private static final int MAX_VAL;

    private AlertType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public boolean isAlarm() {
        return this == ALARM;
    }

    public boolean matches(Integer val) {
        return val != null && (val & this.value) == this.value;
    }

    public static void check(Integer val) {
        if (val == null || val < 0 || val > MAX_VAL) {
            throw new IllegalArgumentException("Invalid alert type val: " + val);
        }
    }

    static {
        for (AlertType e : AlertType.values()) {
            int n = e.value();
            if (n >= 1 && (n & n - 1) == 0) continue;
            throw new Error("Invalid Alert type value definition: " + (Object)((Object)e));
        }
        Enums.checkDuplicated(AlertType.class, AlertType::value);
        MAX_VAL = Arrays.stream(AlertType.values()).mapToInt(AlertType::value).reduce(0, (a, b) -> a ^ b);
    }
}

