/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;

public enum JobType implements IntValueEnum<JobType>
{
    GENERAL(1, "\u5e38\u89c4"),
    WORKFLOW(2, "\u5de5\u4f5c\u6d41(DAG)");

    private final int value;
    private final String desc;
    private static final JobType[] VALUES;

    private JobType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public boolean isGeneral() {
        return this == GENERAL;
    }

    public boolean isWorkflow() {
        return this == WORKFLOW;
    }

    public static JobType of(int value) {
        for (JobType e : VALUES) {
            if (e.value() != value) continue;
            return e;
        }
        throw new IllegalArgumentException("Invalid job type value: " + value);
    }

    static {
        VALUES = JobType.values();
    }
}

