/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.concurrent.ThreadPoolExecutors;
import cn.ponfee.disjob.common.concurrent.Threads;
import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.common.exception.Throwables;
import cn.ponfee.disjob.common.spring.SpringContextHolder;
import cn.ponfee.disjob.common.util.NetUtils;
import cn.ponfee.disjob.common.util.TablePrinter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CoreUtils.class);
    public static final Interner<Long> INSTANCE_LOCK_POOL = Interners.newWeakInterner();

    public static String getLocalHost() {
        return CoreUtils.getLocalHost(SpringContextHolder.getProperty((String)"disjob.bound.server.host"));
    }

    public static String getLocalHost(String specifiedHost) {
        String host = specifiedHost;
        if (CoreUtils.isValidHost(host, "specified")) {
            return host;
        }
        host = System.getProperty("disjob.bound.server.host");
        if (CoreUtils.isValidHost(host, "System#getProperty")) {
            return host;
        }
        host = System.getenv("disjob.bound.server.host");
        if (CoreUtils.isValidHost(host, "System#getenv")) {
            return host;
        }
        host = NetUtils.getLocalHost();
        if (CoreUtils.isValidHost(host, "NetUtils#getLocalHost")) {
            return host;
        }
        throw new Error("Not found available server host.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R doInSynchronized(Long lock, Throwables.ThrowingSupplier<R, ?> action) throws Throwable {
        Long l = (Long)INSTANCE_LOCK_POOL.intern((Object)lock);
        synchronized (l) {
            return (R)action.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doInSynchronized(Long lock, Throwables.ThrowingRunnable<?> action, Supplier<String> message) {
        Throwable t = null;
        try {
            CoreUtils.doInSynchronized(lock, action);
        }
        catch (Throwable e) {
            t = e;
            LOG.error(message.get(), t);
        }
        finally {
            if (CoreUtils.isCurrentThreadInterrupted(t)) {
                boolean interrupted = Thread.currentThread().isInterrupted();
                LOG.info("Do synchronized retry interrupted {}, {}", (Object)interrupted, (Object)message.get());
                ThreadPoolExecutors.commonThreadPool().execute(() -> {
                    try {
                        CoreUtils.doInSynchronized(lock, action);
                    }
                    catch (Throwable e) {
                        LOG.error("Do synchronized retry error, " + (String)message.get(), e);
                    }
                });
            }
            Threads.interruptIfNecessary((Throwable)t);
        }
    }

    public static void checkClobMaximumLength(String text, String name) {
        int length = StringUtils.length((CharSequence)text);
        if (length > 65535) {
            throw new IllegalArgumentException(name + " length too large: " + length);
        }
    }

    public static String trimRequired(String text, int maximumLength, String name) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw new IllegalArgumentException(name + " cannot be blank");
        }
        return CoreUtils.trimOptional(text, maximumLength, name);
    }

    public static String trimOptional(String text, int maximumLength, String name) {
        String str = StringUtils.trim((String)text);
        int length = StringUtils.length((CharSequence)str);
        if (length > maximumLength) {
            throw new IllegalArgumentException(name + " length exceed limit: " + length + " > " + maximumLength);
        }
        return str;
    }

    public static String buildCacheStats(Cache<?, ?> cache, String cacheName) {
        CacheStats stats = cache.stats();
        String header = "Cache analytics: " + cacheName;
        String hitRate = stats.requestCount() == 0L ? "-" : String.format("%.2f%%", stats.hitRate() * 100.0);
        String loadExceptionRate = stats.loadCount() == 0L ? "-" : String.format("%.2f%%", stats.loadExceptionRate() * 100.0);
        String averageLoadPenalty = stats.loadCount() == 0L ? "-" : Dates.formatDuration((long)TimeUnit.NANOSECONDS.toMillis((long)stats.averageLoadPenalty()));
        List<String> rows = Arrays.asList("Cache size: " + cache.size(), String.format("Hit rate: %s (%d/%d)", hitRate, stats.hitCount(), stats.requestCount()), String.format("Load exception rate: %s (%d/%d)", loadExceptionRate, stats.loadExceptionCount(), stats.loadCount()), "Average load penalty: " + averageLoadPenalty, "Eviction count: " + stats.evictionCount());
        return TablePrinter.HALF.print(header, rows);
    }

    private static boolean isValidHost(String host, String from) {
        if (StringUtils.isBlank((CharSequence)host)) {
            return false;
        }
        if (!NetUtils.isValidLocalHost((String)host)) {
            LOG.warn("Invalid server host configured {}: {}", (Object)from, (Object)host);
            return false;
        }
        if (!NetUtils.isReachableHost((String)host)) {
            LOG.warn("Unreachable server host configured {}: {}", (Object)from, (Object)host);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doInSynchronized(Long lock, Throwables.ThrowingRunnable<?> action) throws Throwable {
        Long l = (Long)INSTANCE_LOCK_POOL.intern((Object)lock);
        synchronized (l) {
            action.run();
        }
    }

    private static boolean isCurrentThreadInterrupted(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof ThreadDeath || t instanceof InterruptedException) {
            return true;
        }
        Thread curThread = Thread.currentThread();
        return curThread.isInterrupted() || Threads.isStopped((Thread)curThread);
    }
}

