/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.core.enums.TokenType;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class Tokens {
    private static final long EXPIRATION_MILLISECONDS = 60000L;

    public static String createAuthentication(String tokenPlain, TokenType type, String group) {
        return Tokens.create(tokenPlain, type, Mode.authentication, group);
    }

    public static String createSignature(String tokenPlain, TokenType type, String group) {
        return Tokens.create(tokenPlain, type, Mode.signature, group);
    }

    public static boolean verifyAuthentication(String tokenSecret, String tokenPlain, TokenType type, String group) {
        return Tokens.verify(tokenSecret, tokenPlain, type, Mode.authentication, group);
    }

    public static boolean verifySignature(String tokenSecret, String tokenPlain, TokenType type, String group) {
        return Tokens.verify(tokenSecret, tokenPlain, type, Mode.signature, group);
    }

    private static String create(String tokenPlain, TokenType type, Mode mode, String group) {
        if (StringUtils.isEmpty((CharSequence)tokenPlain)) {
            return null;
        }
        String expiration = Long.toString(System.currentTimeMillis() + 60000L);
        return Tokens.secret(tokenPlain, type, mode, expiration, group) + "." + expiration;
    }

    private static boolean verify(String tokenSecret, String tokenPlain, TokenType type, Mode mode, String group) {
        if (StringUtils.isEmpty((CharSequence)tokenPlain)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)tokenSecret)) {
            return false;
        }
        String[] array = tokenSecret.split("\\.");
        if (array.length != 2) {
            return false;
        }
        String actual = array[0];
        String expiration = array[1];
        if (Long.parseLong(expiration) < System.currentTimeMillis()) {
            return false;
        }
        String expect = Tokens.secret(tokenPlain, type, mode, expiration, group);
        return actual.equals(expect);
    }

    private static String secret(String tokenPlain, TokenType type, Mode mode, String expiration, String group) {
        Assert.notNull((Object)((Object)type), (String)"Type cannot be null.");
        Assert.notNull((Object)((Object)mode), (String)"Mode cannot be null.");
        Assert.hasText((String)group, (String)"Group cannot be empty.");
        String payload = type.name() + "." + mode.name() + "." + expiration + "." + group;
        HmacUtils hm = new HmacUtils(HmacAlgorithms.HMAC_SHA_1, tokenPlain.getBytes(StandardCharsets.UTF_8));
        byte[] digest = hm.hmac(payload.getBytes(StandardCharsets.UTF_8));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }

    private static enum Mode {
        authentication,
        signature;

    }
}

