/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.core.base.Server;
import cn.ponfee.disjob.core.base.Tokens;
import cn.ponfee.disjob.core.dto.worker.AuthenticationParam;
import cn.ponfee.disjob.core.enums.TokenType;
import cn.ponfee.disjob.core.exception.AuthenticationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

@JsonSerialize(using=JacksonSerializer.class)
@JsonDeserialize(using=JacksonDeserializer.class)
public class Worker
extends Server
implements Comparable<Worker> {
    private static final long serialVersionUID = 8981019172872301692L;
    private final String group;
    private final String workerId;
    private final transient String serializedValue;

    public Worker(String group, String workerId, String host, int port) {
        super(host, port);
        this.group = Worker.check(group);
        this.workerId = Worker.check(workerId);
        this.serializedValue = this.group + ":" + this.workerId + ":" + this.host + ":" + this.port;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.group, this.workerId, this.host, this.port);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Worker) || !super.equals(obj)) {
            return false;
        }
        Worker that = (Worker)obj;
        return this.group.equals(that.group) && this.workerId.equals(that.workerId);
    }

    @Override
    public final String serialize() {
        return this.serializedValue;
    }

    public boolean matches(Worker other) {
        return super.equals(other) && this.equalsGroup(other.group);
    }

    public boolean equalsGroup(String group) {
        return this.group.equals(group);
    }

    public String getGroup() {
        return this.group;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public static Worker deserialize(byte[] bytes, Charset charset) {
        return Worker.deserialize(new String(bytes, charset));
    }

    public static Worker deserialize(String text) {
        String[] array = text.split(":", 4);
        Assert.isTrue((array.length == 4 ? 1 : 0) != 0, () -> "Invalid worker value: " + text);
        return new Worker(array[0], array[1], array[2], Integer.parseInt(array[3]));
    }

    public static Local local() {
        return Local.instance;
    }

    @Override
    public int compareTo(Worker that) {
        int n = this.workerId.compareTo(that.workerId);
        if (n != 0) {
            return n;
        }
        n = this.host.compareTo(that.host);
        if (n != 0) {
            return n;
        }
        n = Integer.compare(this.port, that.port);
        if (n != 0) {
            return n;
        }
        return this.group.compareTo(that.group);
    }

    static class JacksonDeserializer
    extends JsonDeserializer<Worker> {
        JacksonDeserializer() {
        }

        public Worker deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
            return Worker.deserialize(p.getText());
        }
    }

    static class JacksonSerializer
    extends JsonSerializer<Worker> {
        JacksonSerializer() {
        }

        public void serialize(Worker value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            if (value == null) {
                generator.writeNull();
            } else {
                generator.writeString(value.serialize());
            }
        }
    }

    public static abstract class Local
    extends Worker {
        private static volatile Local instance = null;
        private final LocalDateTime startupTime;

        private Local(String group, String workerId, String host, int port) {
            super(group, workerId, host, port);
            SingletonClassConstraint.constrain(Local.class);
            this.startupTime = LocalDateTime.now();
        }

        public final LocalDateTime getStartupTime() {
            return this.startupTime;
        }

        public abstract String getSupervisorContextPath();

        public abstract Map<String, String> createWorkerAuthenticationHeaders();

        public abstract String createWorkerSignatureToken();

        public abstract void verifySupervisorAuthenticationToken(AuthenticationParam var1);

        private static synchronized Local create(final String group, String workerId, String host, int port, final String wToken, final String sToken, final String supervisorContextPath) {
            if (instance != null) {
                throw new Error("Local worker already created.");
            }
            instance = new Local(group, workerId, host, port){
                private final String workerToken;
                private final String supervisorToken;
                {
                    super(group2, workerId, host, port);
                    this.workerToken = StringUtils.trim((String)wToken);
                    this.supervisorToken = StringUtils.trim((String)sToken);
                }

                @Override
                public String getSupervisorContextPath() {
                    return supervisorContextPath;
                }

                @Override
                public Map<String, String> createWorkerAuthenticationHeaders() {
                    if (StringUtils.isEmpty((CharSequence)this.workerToken)) {
                        return Collections.singletonMap("X-Disjob-Group", group);
                    }
                    String workerAuthenticationToken = Tokens.createAuthentication(this.workerToken, TokenType.worker, group);
                    Assert.hasText((String)workerAuthenticationToken, (String)"Worker authentication token cannot be blank.");
                    return ImmutableMap.of((Object)"X-Disjob-Group", (Object)group, (Object)"X-Disjob-Token", (Object)workerAuthenticationToken);
                }

                @Override
                public String createWorkerSignatureToken() {
                    return Tokens.createSignature(this.workerToken, TokenType.worker, group);
                }

                @Override
                public void verifySupervisorAuthenticationToken(AuthenticationParam param) {
                    String tokenSecret;
                    String string = tokenSecret = param == null ? null : param.getSupervisorAuthenticationToken();
                    if (!Tokens.verifyAuthentication(tokenSecret, this.supervisorToken, TokenType.supervisor, group)) {
                        throw new AuthenticationException("Authenticate failed.");
                    }
                }
            };
            return instance;
        }
    }
}

