/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.registry.nacos.configuration;

import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.registry.WorkerRegistry;
import cn.ponfee.disjob.registry.configuration.BaseServerRegistryAutoConfiguration;
import cn.ponfee.disjob.registry.nacos.NacosSupervisorRegistry;
import cn.ponfee.disjob.registry.nacos.NacosWorkerRegistry;
import cn.ponfee.disjob.registry.nacos.configuration.NacosRegistryProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={NacosRegistryProperties.class})
public class NacosServerRegistryAutoConfiguration
extends BaseServerRegistryAutoConfiguration {
    @ConditionalOnBean(value={Supervisor.Current.class})
    @Bean
    public SupervisorRegistry supervisorRegistry(NacosRegistryProperties config) {
        return new NacosSupervisorRegistry(config);
    }

    @ConditionalOnBean(value={Worker.Current.class})
    @Bean
    public WorkerRegistry workerRegistry(NacosRegistryProperties config) {
        return new NacosWorkerRegistry(config);
    }
}

