/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.registry.nacos;

import cn.ponfee.disjob.common.exception.Throwables;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;

public class NacosClient {
    private final NamingService namingService;
    private final String groupName;
    private final Map<String, Watcher> watchers = new ConcurrentHashMap<String, Watcher>();

    public NacosClient(Properties config, String groupName) throws NacosException {
        this.namingService = NacosFactory.createNamingService((Properties)config);
        this.groupName = groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void watch(String serviceName, Consumer<List<Instance>> listener) throws NacosException {
        if (this.watchers.containsKey(serviceName)) {
            throw new IllegalStateException("Service name already watched: " + serviceName);
        }
        CountDownLatch latch = new CountDownLatch(1);
        try {
            Watcher watcher = new Watcher(listener, latch);
            this.namingService.subscribe(serviceName, this.groupName, (EventListener)watcher);
            listener.accept(this.namingService.selectInstances(serviceName, this.groupName, true));
            this.watchers.put(serviceName, watcher);
        }
        finally {
            latch.countDown();
        }
    }

    public synchronized void unwatch(String serviceName) {
        Watcher watcher = this.watchers.remove(serviceName);
        if (watcher != null) {
            Throwables.ThrowingRunnable.doCaught(() -> this.namingService.unsubscribe(serviceName, this.groupName, (EventListener)watcher));
        }
    }

    public String getServerStatus() {
        return this.namingService.getServerStatus();
    }

    public void registerInstance(String serviceName, Instance instance) throws NacosException {
        this.namingService.registerInstance(serviceName, this.groupName, instance);
    }

    public void deregisterInstance(String serviceName, Instance instance) throws NacosException {
        this.namingService.deregisterInstance(serviceName, this.groupName, instance);
    }

    public List<Instance> getAllInstances(String serviceName) throws NacosException {
        return this.namingService.getAllInstances(serviceName, this.groupName);
    }

    public synchronized void close() {
        new ArrayList<String>(this.watchers.keySet()).forEach(this::unwatch);
        Throwables.ThrowingRunnable.doCaught(() -> ((NamingService)this.namingService).shutDown());
    }

    private static class Watcher
    implements EventListener {
        private final Consumer<List<Instance>> listener;
        private final CountDownLatch latch;

        Watcher(Consumer<List<Instance>> listener, CountDownLatch latch) {
            this.listener = listener;
            this.latch = latch;
        }

        public void onEvent(Event event) {
            if (event instanceof NamingEvent) {
                Throwables.ThrowingRunnable.doCaught(this.latch::await);
                this.listener.accept(((NamingEvent)event).getInstances());
            }
        }
    }
}

