/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.registry.nacos;

import cn.ponfee.disjob.core.base.Server;
import cn.ponfee.disjob.registry.AbstractRegistryProperties;
import cn.ponfee.disjob.registry.RegistryException;
import cn.ponfee.disjob.registry.ServerRegistry;
import cn.ponfee.disjob.registry.ServerRole;
import cn.ponfee.disjob.registry.nacos.NacosClient;
import cn.ponfee.disjob.registry.nacos.configuration.NacosRegistryProperties;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class NacosServerRegistry<R extends Server, D extends Server>
extends ServerRegistry<R, D> {
    private final NacosClient client;

    protected NacosServerRegistry(NacosRegistryProperties config) {
        super((AbstractRegistryProperties)config, ':');
        String groupName = StringUtils.isBlank((CharSequence)config.getNamespace()) ? "DEFAULT_GROUP" : config.getNamespace().trim();
        NacosClient client0 = null;
        try {
            this.client = client0 = new NacosClient(config.toProperties(), groupName);
            this.client.watch(this.discoveryRootPath, this::doRefreshDiscoveryServers);
        }
        catch (Throwable t) {
            if (client0 != null) {
                client0.close();
            }
            throw new RegistryException("Nacos registry init error: " + (Object)((Object)config), t);
        }
    }

    public final boolean isConnected() {
        return "UP".equals(this.client.getServerStatus());
    }

    public final void register(R server) {
        if (this.state.isStopped()) {
            return;
        }
        Instance instance = this.createInstance(server);
        try {
            this.client.registerInstance(this.registryRootPath, instance);
            this.registered.add(server);
            this.log.info("Nacos server registered: {}, {}", (Object)this.registryRole, server);
        }
        catch (Throwable e) {
            throw new RegistryException("Nacos server register failed: " + server, e);
        }
    }

    public final void deregister(R server) {
        Instance instance = this.createInstance(server);
        try {
            this.registered.remove(server);
            this.client.deregisterInstance(this.registryRootPath, instance);
            this.log.info("Nacos server deregister: {}, {}", (Object)this.registryRole, server);
        }
        catch (Throwable t) {
            this.log.error("Nacos server deregister error.", t);
        }
    }

    public List<R> getRegisteredServers() {
        try {
            List<Instance> list = this.client.getAllInstances(this.registryRootPath);
            return this.deserializeRegistryServers(list, Instance::getInstanceId);
        }
        catch (NacosException e) {
            return (List)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    @PreDestroy
    public void close() {
        if (!this.state.stop()) {
            return;
        }
        this.registered.forEach(this::deregister);
        this.client.close();
        super.close();
    }

    private Instance createInstance(R server) {
        Instance instance = new Instance();
        instance.setInstanceId(server.serialize());
        instance.setIp(server.getHost());
        instance.setPort(server.getPort());
        return instance;
    }

    private synchronized void doRefreshDiscoveryServers(List<Instance> instances) {
        List servers;
        if (CollectionUtils.isEmpty(instances)) {
            this.log.warn("Not discovered available {} from nacos.", (Object)this.discoveryRole);
            servers = Collections.emptyList();
        } else {
            servers = instances.stream().map(Instance::getInstanceId).filter(Objects::nonNull).map(arg_0 -> ((ServerRole)this.discoveryRole).deserialize(arg_0)).collect(Collectors.toList());
        }
        this.refreshDiscoveredServers(servers);
    }
}

