/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.registry.nacos;

import cn.ponfee.disjob.core.base.Server;
import cn.ponfee.disjob.registry.AbstractRegistryProperties;
import cn.ponfee.disjob.registry.RegistryException;
import cn.ponfee.disjob.registry.ServerRegistry;
import cn.ponfee.disjob.registry.nacos.NacosClient;
import cn.ponfee.disjob.registry.nacos.configuration.NacosRegistryProperties;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.web.client.RestTemplate;

public abstract class NacosServerRegistry<R extends Server, D extends Server>
extends ServerRegistry<R, D> {
    private final NacosClient client;

    protected NacosServerRegistry(NacosRegistryProperties config, RestTemplate restTemplate) {
        super((AbstractRegistryProperties)config, restTemplate, ':');
        String groupName = StringUtils.isBlank((CharSequence)config.getNamespace()) ? "DEFAULT_GROUP" : config.getNamespace().trim();
        NacosClient client0 = null;
        try {
            this.client = client0 = new NacosClient(config.toProperties(), groupName);
            this.client.watch(this.discoveryRootPath, instances -> this.refreshDiscoveryServers(this.extract((List<Instance>)instances)));
            this.log.info("Nacos server registry initialized: {}", (Object)this.client);
        }
        catch (Throwable t) {
            if (client0 != null) {
                client0.close();
            }
            throw new RegistryException("Nacos registry init error: " + (Object)((Object)config), t);
        }
    }

    public final boolean isConnected() {
        return "UP".equals(this.client.getServerStatus());
    }

    public final void register(R server) {
        if (this.state.isStopped()) {
            return;
        }
        Instance instance = this.createInstance(server);
        try {
            this.client.registerInstance(this.registryRootPath, instance);
            this.registered.add(server);
            this.log.info("Nacos server registered: {}, {}", (Object)this.registryRole, server);
        }
        catch (Throwable e) {
            throw new RegistryException("Nacos server register failed: " + server, e);
        }
    }

    public final void deregister(R server) {
        Instance instance = this.createInstance(server);
        try {
            this.registered.remove(server);
            this.client.deregisterInstance(this.registryRootPath, instance);
            this.log.info("Nacos server deregister success: {}", server);
        }
        catch (Throwable t) {
            this.log.error("Nacos server deregister error: " + server, t);
        }
    }

    public List<R> getRegisteredServers() {
        try {
            List<Instance> instances = this.client.getAllInstances(this.registryRootPath);
            return this.deserializeServers(this.extract(instances), this.registryRole);
        }
        catch (NacosException e) {
            return (List)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    @PreDestroy
    public void close() {
        if (!this.state.stop()) {
            return;
        }
        this.registered.forEach(this::deregister);
        this.client.close();
        super.close();
    }

    private Instance createInstance(R server) {
        Instance instance = new Instance();
        instance.setInstanceId(server.serialize());
        instance.setIp(server.getHost());
        instance.setPort(server.getPort());
        return instance;
    }

    private List<String> extract(List<Instance> list) {
        if (list == null) {
            return null;
        }
        return list.stream().filter(Objects::nonNull).map(Instance::getInstanceId).collect(Collectors.toList());
    }
}

