/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.registry.nacos.configuration;

import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.registry.WorkerRegistry;
import cn.ponfee.disjob.registry.configuration.BaseServerRegistryAutoConfiguration;
import cn.ponfee.disjob.registry.nacos.NacosSupervisorRegistry;
import cn.ponfee.disjob.registry.nacos.NacosWorkerRegistry;
import cn.ponfee.disjob.registry.nacos.configuration.NacosRegistryProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestTemplate;

@EnableConfigurationProperties(value={NacosRegistryProperties.class})
public class NacosServerRegistryAutoConfiguration
extends BaseServerRegistryAutoConfiguration {
    @ConditionalOnBean(value={Supervisor.Local.class})
    @Bean
    public SupervisorRegistry supervisorRegistry(NacosRegistryProperties config, @Qualifier(value="disjob.bean.rest-template") RestTemplate restTemplate) {
        return new NacosSupervisorRegistry(config, restTemplate);
    }

    @ConditionalOnBean(value={Worker.Local.class})
    @Bean
    public WorkerRegistry workerRegistry(NacosRegistryProperties config, @Qualifier(value="disjob.bean.rest-template") RestTemplate restTemplate) {
        return new NacosWorkerRegistry(config, restTemplate);
    }
}

