/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.registry.redis.configuration;

import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.registry.WorkerRegistry;
import cn.ponfee.disjob.registry.configuration.BaseServerRegistryAutoConfiguration;
import cn.ponfee.disjob.registry.redis.RedisSupervisorRegistry;
import cn.ponfee.disjob.registry.redis.RedisWorkerRegistry;
import cn.ponfee.disjob.registry.redis.configuration.RedisRegistryProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;

@EnableConfigurationProperties(value={RedisRegistryProperties.class})
public class RedisServerRegistryAutoConfiguration
extends BaseServerRegistryAutoConfiguration {
    @ConditionalOnBean(value={Supervisor.Local.class})
    @Bean
    public SupervisorRegistry supervisorRegistry(StringRedisTemplate stringRedisTemplate, RedisRegistryProperties config) {
        return new RedisSupervisorRegistry(stringRedisTemplate, config);
    }

    @ConditionalOnBean(value={Worker.Local.class})
    @Bean
    public WorkerRegistry workerRegistry(StringRedisTemplate stringRedisTemplate, RedisRegistryProperties config) {
        return new RedisWorkerRegistry(stringRedisTemplate, config);
    }
}

