/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.registry.redis.configuration;

import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.registry.WorkerRegistry;
import cn.ponfee.disjob.registry.configuration.BaseServerRegistryAutoConfiguration;
import cn.ponfee.disjob.registry.redis.RedisSupervisorRegistry;
import cn.ponfee.disjob.registry.redis.RedisWorkerRegistry;
import cn.ponfee.disjob.registry.redis.configuration.RedisRegistryProperties;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.client.RestTemplate;

@AutoConfigureOrder(value=0x7FFFFFFF)
@EnableConfigurationProperties(value={RedisRegistryProperties.class})
public class RedisServerRegistryAutoConfiguration
extends BaseServerRegistryAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public StringRedisTemplateWrapper stringRedisTemplateWrapper(StringRedisTemplate stringRedisTemplate) {
        return new StringRedisTemplateWrapper(stringRedisTemplate);
    }

    @ConditionalOnBean(value={Supervisor.Local.class})
    @Bean
    public SupervisorRegistry supervisorRegistry(RedisRegistryProperties config, @Qualifier(value="disjob.bean.rest-template") RestTemplate restTemplate, StringRedisTemplateWrapper wrapper) {
        return new RedisSupervisorRegistry(config, restTemplate, wrapper.stringRedisTemplate);
    }

    @ConditionalOnBean(value={Worker.Local.class})
    @Bean
    public WorkerRegistry workerRegistry(RedisRegistryProperties config, @Qualifier(value="disjob.bean.rest-template") RestTemplate restTemplate, StringRedisTemplateWrapper wrapper) {
        return new RedisWorkerRegistry(config, restTemplate, wrapper.stringRedisTemplate);
    }

    public static class StringRedisTemplateWrapper {
        private final StringRedisTemplate stringRedisTemplate;

        public StringRedisTemplateWrapper(StringRedisTemplate stringRedisTemplate) {
            this.stringRedisTemplate = Objects.requireNonNull(stringRedisTemplate);
        }
    }
}

