/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.registry.zookeeper.configuration;

import cn.ponfee.disjob.registry.AbstractRegistryProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="disjob.registry.zookeeper")
public class ZookeeperRegistryProperties
extends AbstractRegistryProperties {
    private static final long serialVersionUID = -8395535372974631095L;
    private String connectString = "localhost:2181";
    private String username;
    private String password;
    private int connectionTimeoutMs = 5000;
    private int sessionTimeoutMs = 60000;
    private int baseSleepTimeMs = 50;
    private int maxRetries = 10;
    private int maxSleepMs = 500;
    private int maxWaitTimeMs = 5000;

    public String authorization() {
        if (StringUtils.isEmpty((CharSequence)this.username)) {
            return StringUtils.isEmpty((CharSequence)this.password) ? null : ":" + this.password;
        }
        return this.username + ":" + (StringUtils.isEmpty((CharSequence)this.password) ? "" : this.password);
    }

    public String getConnectString() {
        return this.connectString;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public int getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public int getBaseSleepTimeMs() {
        return this.baseSleepTimeMs;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getMaxSleepMs() {
        return this.maxSleepMs;
    }

    public int getMaxWaitTimeMs() {
        return this.maxWaitTimeMs;
    }

    public void setConnectString(String connectString) {
        this.connectString = connectString;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public void setSessionTimeoutMs(int sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
    }

    public void setBaseSleepTimeMs(int baseSleepTimeMs) {
        this.baseSleepTimeMs = baseSleepTimeMs;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setMaxSleepMs(int maxSleepMs) {
        this.maxSleepMs = maxSleepMs;
    }

    public void setMaxWaitTimeMs(int maxWaitTimeMs) {
        this.maxWaitTimeMs = maxWaitTimeMs;
    }
}

