/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.registry.zookeeper;

import cn.ponfee.disjob.common.exception.Throwables;
import cn.ponfee.disjob.core.base.Server;
import cn.ponfee.disjob.registry.RegistryException;
import cn.ponfee.disjob.registry.ServerRegistry;
import cn.ponfee.disjob.registry.ServerRole;
import cn.ponfee.disjob.registry.zookeeper.CuratorFrameworkClient;
import cn.ponfee.disjob.registry.zookeeper.configuration.ZookeeperRegistryProperties;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;

public abstract class ZookeeperServerRegistry<R extends Server, D extends Server>
extends ServerRegistry<R, D> {
    private static final int CREATE_EPHEMERAL_FAIL_RETRIES = 3;
    private final CuratorFrameworkClient client;

    protected ZookeeperServerRegistry(ZookeeperRegistryProperties config) {
        super(config.getNamespace(), '/');
        String registryRootPath0 = this.separator + this.registryRootPath;
        String discoveryRootPath0 = this.separator + this.discoveryRootPath;
        CountDownLatch latch = new CountDownLatch(1);
        try {
            this.client = new CuratorFrameworkClient(config, client0 -> {
                if (this.closed.get()) {
                    return;
                }
                for (Server server : this.registered) {
                    try {
                        client0.createEphemeral(this.buildRegistryPath(server), 3);
                    }
                    catch (Throwable t) {
                        this.log.error("Re-registry server to zookeeper occur error: " + server, t);
                    }
                }
            });
            this.client.createPersistent(registryRootPath0);
            this.client.createPersistent(discoveryRootPath0);
            this.client.watchChildChanged(discoveryRootPath0, latch, this::doRefreshDiscoveryServers);
        }
        catch (Exception e) {
            throw new RegistryException("Zookeeper registry init error: " + (Object)((Object)config), (Throwable)e);
        }
        finally {
            latch.countDown();
        }
    }

    public final boolean isConnected() {
        return this.client.isConnected();
    }

    public final void register(R server) {
        if (this.closed.get()) {
            return;
        }
        try {
            this.client.createEphemeral(this.buildRegistryPath(server), 3);
            this.registered.add(server);
            this.log.info("Server registered: {} | {}", (Object)this.registryRole.name(), server);
        }
        catch (Throwable e) {
            throw new RegistryException("Zookeeper server register failed: " + server, e);
        }
    }

    public final void deregister(R server) {
        String registryPath = this.buildRegistryPath(server);
        try {
            this.registered.remove(server);
            this.client.deletePath(registryPath);
            this.log.info("Server deregister: {} | {}", (Object)this.registryRole.name(), server);
        }
        catch (Throwable e) {
            this.log.error("Deregister to zookeeper failed: " + registryPath, e);
        }
    }

    @PreDestroy
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.registered.forEach(this::deregister);
        Throwables.ThrowingRunnable.execute(this.client::close);
        this.registered.clear();
        super.close();
    }

    private String buildRegistryPath(R server) {
        return this.separator + this.registryRootPath + this.separator + server.serialize();
    }

    private synchronized void doRefreshDiscoveryServers(List<String> list) {
        List servers;
        this.log.info("Watched servers {}", list);
        if (CollectionUtils.isEmpty(list)) {
            this.log.warn("Not discovered available {} from zookeeper.", (Object)this.discoveryRole.name());
            servers = Collections.emptyList();
        } else {
            servers = list.stream().filter(Objects::nonNull).map(arg_0 -> ((ServerRole)this.discoveryRole).deserialize(arg_0)).collect(Collectors.toList());
        }
        this.refreshDiscoveredServers(servers);
    }
}

