/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.registry.zookeeper.configuration;

import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.registry.WorkerRegistry;
import cn.ponfee.disjob.registry.configuration.BaseServerRegistryAutoConfiguration;
import cn.ponfee.disjob.registry.zookeeper.ZookeeperSupervisorRegistry;
import cn.ponfee.disjob.registry.zookeeper.ZookeeperWorkerRegistry;
import cn.ponfee.disjob.registry.zookeeper.configuration.ZookeeperRegistryProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestTemplate;

@EnableConfigurationProperties(value={ZookeeperRegistryProperties.class})
public class ZookeeperServerRegistryAutoConfiguration
extends BaseServerRegistryAutoConfiguration {
    @ConditionalOnBean(value={Supervisor.Local.class})
    @Bean
    public SupervisorRegistry supervisorRegistry(ZookeeperRegistryProperties config, @Qualifier(value="disjob.bean.rest-template") RestTemplate restTemplate) {
        return new ZookeeperSupervisorRegistry(config, restTemplate);
    }

    @ConditionalOnBean(value={Worker.Local.class})
    @Bean
    public WorkerRegistry workerRegistry(ZookeeperRegistryProperties config, @Qualifier(value="disjob.bean.rest-template") RestTemplate restTemplate) {
        return new ZookeeperWorkerRegistry(config, restTemplate);
    }
}

