/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.base;

import cn.ponfee.disjob.common.model.PageResponse;
import cn.ponfee.disjob.common.spring.RpcController;
import cn.ponfee.disjob.core.enums.ExecuteState;
import cn.ponfee.disjob.core.enums.JobState;
import cn.ponfee.disjob.core.enums.Operations;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.core.openapi.supervisor.SupervisorOpenapi;
import cn.ponfee.disjob.core.openapi.supervisor.converter.SchedJobConverter;
import cn.ponfee.disjob.core.openapi.supervisor.request.AddSchedJobRequest;
import cn.ponfee.disjob.core.openapi.supervisor.request.SchedInstancePageRequest;
import cn.ponfee.disjob.core.openapi.supervisor.request.SchedJobPageRequest;
import cn.ponfee.disjob.core.openapi.supervisor.request.UpdateSchedJobRequest;
import cn.ponfee.disjob.core.openapi.supervisor.response.SchedInstanceResponse;
import cn.ponfee.disjob.core.openapi.supervisor.response.SchedJobResponse;
import cn.ponfee.disjob.core.openapi.supervisor.response.SchedTaskResponse;
import cn.ponfee.disjob.supervisor.manager.DistributedJobManager;
import cn.ponfee.disjob.supervisor.manager.DistributedJobQuerier;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorOpenapiProvider
implements SupervisorOpenapi,
RpcController {
    protected static final Logger LOG = LoggerFactory.getLogger(SupervisorOpenapiProvider.class);
    private final DistributedJobManager jobManager;
    private final DistributedJobQuerier jobQuerier;

    public SupervisorOpenapiProvider(DistributedJobManager jobManager, DistributedJobQuerier jobQuerier) {
        this.jobManager = jobManager;
        this.jobQuerier = jobQuerier;
    }

    public void addJob(AddSchedJobRequest req) throws JobException {
        this.jobManager.addJob(req.tosSchedJob());
    }

    public void updateJob(UpdateSchedJobRequest req) throws JobException {
        LOG.info("Do updating sched job {}", (Object)req.getJobId());
        this.jobManager.updateJob(req.tosSchedJob());
    }

    public void deleteJob(long jobId) {
        LOG.info("Do deleting sched job {}", (Object)jobId);
        this.jobManager.deleteJob(jobId);
    }

    public Boolean changeJobState(long jobId, int jobState) {
        LOG.info("Do change sched job state {}", (Object)jobId);
        return this.jobManager.changeJobState(jobId, JobState.DISABLE);
    }

    public void triggerJob(long jobId) throws JobException {
        LOG.info("Do manual trigger the sched job {}", (Object)jobId);
        this.jobManager.triggerJob(jobId);
    }

    public SchedJobResponse getJob(long jobId) {
        SchedJob schedJob = this.jobManager.getJob(jobId);
        return SchedJobConverter.INSTANCE.convert(schedJob);
    }

    public PageResponse<SchedJobResponse> queryJobForPage(SchedJobPageRequest pageRequest) {
        return this.jobQuerier.queryJobForPage(pageRequest);
    }

    public Boolean pauseInstance(long instanceId) {
        LOG.info("Do pausing sched instance {}", (Object)instanceId);
        return this.jobManager.pauseInstance(instanceId);
    }

    public Boolean cancelInstance(long instanceId) {
        LOG.info("Do canceling sched instance {}", (Object)instanceId);
        return this.jobManager.cancelInstance(instanceId, Operations.MANUAL_CANCEL);
    }

    public Boolean resumeInstance(long instanceId) {
        LOG.info("Do resuming sched instance {}", (Object)instanceId);
        return this.jobManager.resumeInstance(instanceId);
    }

    public void changeInstanceState(long instanceId, int targetExecuteState) {
        ExecuteState.of((Integer)targetExecuteState);
        LOG.info("Do force change state {} | {}", (Object)instanceId, (Object)targetExecuteState);
        this.jobManager.changeInstanceState(instanceId, ExecuteState.of((Integer)targetExecuteState));
    }

    public void deleteInstance(long instanceId) {
        LOG.info("Do deleting sched instance {}", (Object)instanceId);
        this.jobManager.deleteInstance(instanceId);
    }

    public SchedInstanceResponse getInstance(long instanceId) {
        SchedInstance instance = this.jobManager.getInstance(instanceId);
        if (instance == null) {
            return null;
        }
        List<SchedTask> tasks = this.jobQuerier.findLargeInstanceTasks(instanceId);
        return SchedInstanceResponse.of((SchedInstance)instance, tasks);
    }

    public List<SchedTaskResponse> getInstanceTasks(long instanceId) {
        List<SchedTask> tasks = this.jobQuerier.findLargeInstanceTasks(instanceId);
        if (tasks == null) {
            return null;
        }
        return tasks.stream().map(arg_0 -> ((SchedJobConverter)SchedJobConverter.INSTANCE).convert(arg_0)).collect(Collectors.toList());
    }

    public PageResponse<SchedInstanceResponse> queryInstanceForPage(SchedInstancePageRequest pageRequest) {
        return this.jobQuerier.queryInstanceForPage(pageRequest);
    }

    public List<SchedInstanceResponse> listInstanceChildren(long pnstanceId) {
        return this.jobQuerier.listInstanceChildren(pnstanceId);
    }
}

