/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.configuration;

import cn.ponfee.disjob.common.lock.DoInLocked;
import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.dispatch.TaskDispatcher;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.supervisor.SupervisorStartup;
import cn.ponfee.disjob.supervisor.configuration.SupervisorProperties;
import cn.ponfee.disjob.supervisor.manager.DistributedJobManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.SmartLifecycle;

public class SupervisorLifecycle
implements SmartLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorLifecycle.class);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final SupervisorStartup supervisorStartup;

    public SupervisorLifecycle(Supervisor currentSupervisor, SupervisorProperties supervisorProperties, SupervisorRegistry supervisorRegistry, DistributedJobManager distributedJobManager, @Qualifier(value="scan-triggering-job-locker") DoInLocked scanTriggeringJobLocker, @Qualifier(value="scan-waiting-instance-locker") DoInLocked scanWaitingInstanceLocker, @Qualifier(value="scan-running-instance-locker") DoInLocked scanRunningInstanceLocker, TaskDispatcher taskDispatcher) {
        this.supervisorStartup = SupervisorStartup.builder().currentSupervisor(currentSupervisor).supervisorProperties(supervisorProperties).supervisorRegistry(supervisorRegistry).distributedJobManager(distributedJobManager).scanTriggeringJobLocker(scanTriggeringJobLocker).scanWaitingInstanceLocker(scanWaitingInstanceLocker).scanRunningInstanceLocker(scanRunningInstanceLocker).taskDispatcher(taskDispatcher).build();
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            LOG.error("Disjob supervisor lifecycle already stated!");
        }
        LOG.info("Disjob supervisor launch begin...");
        this.supervisorStartup.start();
        LOG.info("Disjob supervisor launch end.");
    }

    public void stop(Runnable callback) {
        if (!this.started.compareAndSet(true, false)) {
            LOG.error("Disjob supervisor lifecycle already stopped!");
        }
        LOG.info("Disjob supervisor stop begin...");
        this.supervisorStartup.stop();
        LOG.info("Disjob supervisor stop end.");
        callback.run();
    }

    public void stop() {
        this.stop(() -> {});
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }
}

