/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.controller;

import cn.ponfee.disjob.common.model.PageResponse;
import cn.ponfee.disjob.common.model.Result;
import cn.ponfee.disjob.common.spring.BaseController;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.core.openapi.supervisor.SupervisorOpenapi;
import cn.ponfee.disjob.core.openapi.supervisor.request.AddSchedJobRequest;
import cn.ponfee.disjob.core.openapi.supervisor.request.SchedInstancePageRequest;
import cn.ponfee.disjob.core.openapi.supervisor.request.SchedJobPageRequest;
import cn.ponfee.disjob.core.openapi.supervisor.request.UpdateSchedJobRequest;
import cn.ponfee.disjob.core.openapi.supervisor.response.SchedInstanceResponse;
import cn.ponfee.disjob.core.openapi.supervisor.response.SchedJobResponse;
import cn.ponfee.disjob.core.openapi.supervisor.response.SchedTaskResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Supervisor web api")
@RestController
@RequestMapping(value={"supervisor/webapi"})
public class SupervisorWebapiController
extends BaseController {
    private final SupervisorOpenapi supervisorOpenapi;

    public SupervisorWebapiController(SupervisorOpenapi supervisorOpenapi) {
        this.supervisorOpenapi = supervisorOpenapi;
    }

    @PostMapping(value={"job/add"})
    public Result<Void> addJob(@RequestBody AddSchedJobRequest req) throws JobException {
        this.supervisorOpenapi.addJob(req);
        return Result.success();
    }

    @PutMapping(value={"job/update"})
    public Result<Void> updateJob(@RequestBody UpdateSchedJobRequest req) throws JobException {
        this.supervisorOpenapi.updateJob(req);
        return Result.success();
    }

    @DeleteMapping(value={"job/delete"})
    public Result<Void> deleteJob(@RequestParam(value="jobId") long jobId) {
        this.supervisorOpenapi.deleteJob(jobId);
        return Result.success();
    }

    @PostMapping(value={"job/state/change"})
    public Result<Boolean> changeJobState(@RequestParam(value="jobId") long jobId, @RequestParam(value="jobState") int jobState) {
        return Result.success((Object)this.supervisorOpenapi.changeJobState(jobId, jobState));
    }

    @PostMapping(value={"job/trigger"})
    public Result<Void> triggerJob(@RequestParam(value="jobId") long jobId) throws JobException {
        this.supervisorOpenapi.triggerJob(jobId);
        return Result.success();
    }

    @GetMapping(value={"job/get"})
    public Result<SchedJobResponse> getJob(@RequestParam(value="jobId") long jobId) {
        return Result.success((Object)this.supervisorOpenapi.getJob(jobId));
    }

    @GetMapping(value={"job/page"})
    public Result<PageResponse<SchedJobResponse>> queryJobForPage(SchedJobPageRequest pageRequest) {
        return Result.success((Object)this.supervisorOpenapi.queryJobForPage(pageRequest));
    }

    @PostMapping(value={"instance/pause"})
    public Result<Boolean> pauseInstance(@RequestParam(value="instanceId") long instanceId) {
        return Result.success((Object)this.supervisorOpenapi.pauseInstance(instanceId));
    }

    @PostMapping(value={"instance/cancel"})
    public Result<Boolean> cancelInstance(@RequestParam(value="instanceId") long instanceId) {
        return Result.success((Object)this.supervisorOpenapi.cancelInstance(instanceId));
    }

    @PostMapping(value={"instance/resume"})
    public Result<Boolean> resumeInstance(@RequestParam(value="instanceId") long instanceId) {
        return Result.success((Object)this.supervisorOpenapi.resumeInstance(instanceId));
    }

    @DeleteMapping(value={"instance/delete"})
    public Result<Void> deleteInstance(@RequestParam(value="instanceId") long instanceId) {
        this.supervisorOpenapi.deleteInstance(instanceId);
        return Result.success();
    }

    @PostMapping(value={"instance/state/change"})
    public Result<Void> changeInstanceState(@RequestParam(value="instanceId") long instanceId, @RequestParam(value="targetExecuteState") int targetExecuteState) {
        this.supervisorOpenapi.changeInstanceState(instanceId, targetExecuteState);
        return Result.success();
    }

    @GetMapping(value={"instance/get"})
    public Result<SchedInstanceResponse> getInstance(@RequestParam(value="instanceId") long instanceId) {
        return Result.success((Object)this.supervisorOpenapi.getInstance(instanceId));
    }

    @GetMapping(value={"instance/tasks"})
    public Result<List<SchedTaskResponse>> getInstanceTasks(@RequestParam(value="instanceId") long instanceId) {
        return Result.success((Object)this.supervisorOpenapi.getInstanceTasks(instanceId));
    }

    @GetMapping(value={"instance/page"})
    public Result<PageResponse<SchedInstanceResponse>> queryInstanceForPage(SchedInstancePageRequest pageRequest) {
        return Result.success((Object)this.supervisorOpenapi.queryInstanceForPage(pageRequest));
    }

    @GetMapping(value={"instance/children"})
    public Result<List<SchedInstanceResponse>> listInstanceChildren(@RequestParam(value="pnstanceId") long pnstanceId) {
        return Result.success((Object)this.supervisorOpenapi.listInstanceChildren(pnstanceId));
    }
}

