/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.instance;

import cn.ponfee.disjob.core.enums.RunType;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.core.param.JobHandlerParam;
import cn.ponfee.disjob.supervisor.instance.TriggerInstance;
import cn.ponfee.disjob.supervisor.instance.TriggerInstanceCreator;
import cn.ponfee.disjob.supervisor.manager.DistributedJobManager;
import java.util.Date;
import java.util.List;

public class NormalInstanceCreator
extends TriggerInstanceCreator<NormalInstance> {
    public NormalInstanceCreator(DistributedJobManager jobManager) {
        super(jobManager);
    }

    @Override
    public NormalInstance create(SchedJob job, RunType runType, long triggerTime) throws JobException {
        Date now = new Date();
        long instanceId = this.jobManager.generateId();
        SchedInstance instance = SchedInstance.create((long)instanceId, (long)job.getJobId(), (RunType)runType, (long)triggerTime, (int)0, (Date)now);
        List<SchedTask> tasks = this.jobManager.splitTasks(JobHandlerParam.from((SchedJob)job), instanceId, now);
        return new NormalInstance(instance, tasks);
    }

    @Override
    public void dispatch(SchedJob job, NormalInstance instance) {
        this.jobManager.dispatch(job, instance.getInstance(), instance.getTasks());
    }

    public static class NormalInstance
    extends TriggerInstance {
        private final List<SchedTask> tasks;

        public NormalInstance(SchedInstance instance, List<SchedTask> tasks) {
            super(instance);
            this.tasks = tasks;
        }

        public List<SchedTask> getTasks() {
            return this.tasks;
        }
    }
}

