/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.manager;

import cn.ponfee.disjob.common.base.IdGenerator;
import cn.ponfee.disjob.common.model.CodeMsg;
import cn.ponfee.disjob.core.base.JobCodeMsg;
import cn.ponfee.disjob.core.base.Server;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.enums.ExecuteState;
import cn.ponfee.disjob.core.enums.Operations;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.core.handle.SplitTask;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.core.param.ExecuteTaskParam;
import cn.ponfee.disjob.core.param.ExecuteTaskParamBuilder;
import cn.ponfee.disjob.core.param.JobHandlerParam;
import cn.ponfee.disjob.dispatch.TaskDispatcher;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.supervisor.base.WorkerServiceClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class AbstractJobManager {
    private static final int MAX_SPLIT_TASK_SIZE = 1000;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IdGenerator idGenerator;
    private final SupervisorRegistry workerDiscover;
    private final TaskDispatcher taskDispatcher;
    private final WorkerServiceClient workerServiceClient;

    public long generateId() {
        return this.idGenerator.generateId();
    }

    public void verifyJob(SchedJob job) throws JobException {
        Assert.hasText((String)job.getJobHandler(), (String)"Job handler cannot be empty.");
        this.workerServiceClient.verify(JobHandlerParam.from((SchedJob)job));
    }

    public List<SchedTask> splitTasks(JobHandlerParam param, long instanceId, Date date) throws JobException {
        if (RouteStrategy.BROADCAST == param.getRouteStrategy()) {
            List discoveredServers = this.workerDiscover.getDiscoveredServers(param.getJobGroup());
            if (discoveredServers.isEmpty()) {
                throw new JobException((CodeMsg)JobCodeMsg.NOT_DISCOVERED_WORKER);
            }
            int count = discoveredServers.size();
            return IntStream.range(0, count).mapToObj(i -> SchedTask.create((String)param.getJobParam(), (long)this.generateId(), (long)instanceId, (int)(i + 1), (int)count, (Date)date, (String)((Worker)discoveredServers.get(i)).serialize())).collect(Collectors.toList());
        }
        List<SplitTask> split = this.workerServiceClient.split(param);
        Assert.notEmpty(split, () -> "Not split any task: " + param);
        Assert.isTrue((split.size() <= 1000 ? 1 : 0) != 0, () -> "Split task size must less than 1000, job=" + param);
        int count = split.size();
        return IntStream.range(0, count).mapToObj(i -> SchedTask.create((String)((SplitTask)split.get(i)).getTaskParam(), (long)this.generateId(), (long)instanceId, (int)(i + 1), (int)count, (Date)date, null)).collect(Collectors.toList());
    }

    public boolean hasAliveExecuting(List<SchedTask> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return false;
        }
        return tasks.stream().filter(e -> ExecuteState.EXECUTING.equals(e.getExecuteState())).map(SchedTask::getWorker).anyMatch(this::isAliveWorker);
    }

    public boolean isAliveWorker(String text) {
        return StringUtils.isNotBlank((CharSequence)text) && this.isAliveWorker(Worker.deserialize((String)text));
    }

    public boolean isDeadWorker(String text) {
        return !this.isAliveWorker(text);
    }

    public boolean isAliveWorker(Worker worker) {
        return worker != null && this.workerDiscover.isDiscoveredServer((Server)worker);
    }

    public boolean isDeadWorker(Worker worker) {
        return !this.isAliveWorker(worker);
    }

    public boolean hasNotDiscoveredWorkers(String group) {
        return CollectionUtils.isEmpty((Collection)this.workerDiscover.getDiscoveredServers(group));
    }

    public boolean hasNotDiscoveredWorkers() {
        return !this.workerDiscover.hasDiscoveredServers();
    }

    public boolean dispatch(SchedJob job, SchedInstance instance, List<SchedTask> tasks) {
        List<Object> list;
        ExecuteTaskParamBuilder builder = ExecuteTaskParam.builder((SchedInstance)instance, (SchedJob)job);
        if (RouteStrategy.BROADCAST.equals(job.getRouteStrategy())) {
            list = new ArrayList(tasks.size());
            for (SchedTask task : tasks) {
                Assert.hasText((String)task.getWorker(), () -> "Broadcast route strategy worker must pre assign: " + task.getTaskId());
                Worker worker = Worker.deserialize((String)task.getWorker());
                if (this.isDeadWorker(worker)) {
                    this.cancelWaitingTask(task.getTaskId());
                    continue;
                }
                list.add(builder.build(Operations.TRIGGER, task.getTaskId().longValue(), instance.getTriggerTime().longValue(), worker));
            }
        } else {
            list = tasks.stream().map(e -> builder.build(Operations.TRIGGER, e.getTaskId().longValue(), instance.getTriggerTime().longValue(), null)).collect(Collectors.toList());
        }
        return this.taskDispatcher.dispatch(list, job.getJobGroup());
    }

    public boolean dispatch(List<ExecuteTaskParam> params) {
        ArrayList<ExecuteTaskParam> list = new ArrayList<ExecuteTaskParam>(params.size());
        for (ExecuteTaskParam param : params) {
            if (RouteStrategy.BROADCAST == param.getRouteStrategy() && this.isDeadWorker(param.getWorker())) {
                this.cancelWaitingTask(param.getTaskId());
                continue;
            }
            list.add(param);
        }
        return this.taskDispatcher.dispatch(list);
    }

    protected abstract boolean cancelWaitingTask(long var1);

    public AbstractJobManager(IdGenerator idGenerator, SupervisorRegistry workerDiscover, TaskDispatcher taskDispatcher, WorkerServiceClient workerServiceClient) {
        this.idGenerator = idGenerator;
        this.workerDiscover = workerDiscover;
        this.taskDispatcher = taskDispatcher;
        this.workerServiceClient = workerServiceClient;
    }
}

