/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.manager;

import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.common.model.PageRequest;
import cn.ponfee.disjob.common.model.PageResponse;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.core.openapi.supervisor.converter.SchedJobConverter;
import cn.ponfee.disjob.core.openapi.supervisor.request.SchedInstancePageRequest;
import cn.ponfee.disjob.core.openapi.supervisor.request.SchedJobPageRequest;
import cn.ponfee.disjob.core.openapi.supervisor.response.SchedInstanceResponse;
import cn.ponfee.disjob.core.openapi.supervisor.response.SchedJobResponse;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedInstanceMapper;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedJobMapper;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedTaskMapper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Component;

@Component
public class DistributedJobQuerier {
    private final SchedJobMapper jobMapper;
    private final SchedTaskMapper taskMapper;
    private final SchedInstanceMapper instanceMapper;

    public DistributedJobQuerier(SchedJobMapper jobMapper, SchedTaskMapper taskMapper, SchedInstanceMapper instanceMapper) {
        this.jobMapper = jobMapper;
        this.taskMapper = taskMapper;
        this.instanceMapper = instanceMapper;
    }

    public SchedTask getTask(long taskId) {
        return this.taskMapper.getByTaskId(taskId);
    }

    public List<SchedTask> findLargeInstanceTasks(long instanceId) {
        return this.taskMapper.findLargeByInstanceId(instanceId);
    }

    public PageResponse<SchedJobResponse> queryJobForPage(SchedJobPageRequest pageRequest) {
        List<SchedJob> list = this.jobMapper.queryPageRecords(pageRequest);
        List rows = list.stream().map(arg_0 -> ((SchedJobConverter)SchedJobConverter.INSTANCE).convert(arg_0)).collect(Collectors.toList());
        long total = pageRequest.isPaged() ? this.jobMapper.queryPageCount(pageRequest) : (long)rows.size();
        return new PageResponse(rows, total, (PageRequest)pageRequest);
    }

    public PageResponse<SchedInstanceResponse> queryInstanceForPage(SchedInstancePageRequest pageRequest) {
        long total;
        if (pageRequest.getEndTime() != null) {
            pageRequest.setEndTime(Dates.endOfDay((Date)pageRequest.getEndTime()));
        }
        List<SchedInstance> list = this.instanceMapper.queryPageRecords(pageRequest);
        List<SchedInstanceResponse> rows = list.stream().map(arg_0 -> ((SchedJobConverter)SchedJobConverter.INSTANCE).convert(arg_0)).collect(Collectors.toList());
        long l = total = pageRequest.isPaged() ? this.instanceMapper.queryPageCount(pageRequest) : (long)rows.size();
        if (pageRequest.isParent()) {
            this.fillIsTreeLeaf(rows);
        }
        return new PageResponse(rows, total, (PageRequest)pageRequest);
    }

    public List<SchedInstanceResponse> listInstanceChildren(long pnstanceId) {
        List<SchedInstanceResponse> rows = this.instanceMapper.selectByPnstanceId(pnstanceId).stream().map(arg_0 -> ((SchedJobConverter)SchedJobConverter.INSTANCE).convert(arg_0)).collect(Collectors.toList());
        this.fillIsTreeLeaf(rows);
        return rows;
    }

    private void fillIsTreeLeaf(List<SchedInstanceResponse> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<Long> instanceIds = list.stream().map(SchedInstanceResponse::getInstanceId).collect(Collectors.toList());
        Map<Long, Integer> map = this.instanceMapper.queryChildCount(instanceIds).stream().collect(Collectors.toMap(e -> MapUtils.getLongValue((Map)e, (Object)"pnstanceId"), e -> MapUtils.getIntValue((Map)e, (Object)"count")));
        list.forEach(e -> {
            Integer count = (Integer)map.get(e.getInstanceId());
            e.setIsTreeLeaf(Integer.valueOf(count == null || count == 0 ? 0 : 1));
        });
    }
}

