/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.common.concurrent.ThreadPoolExecutors;
import cn.ponfee.disjob.common.concurrent.Threads;
import cn.ponfee.disjob.common.model.PageResponse;
import cn.ponfee.disjob.common.spring.TransactionUtils;
import cn.ponfee.disjob.common.util.Functions;
import cn.ponfee.disjob.core.base.Tokens;
import cn.ponfee.disjob.core.exception.GroupNotFoundException;
import cn.ponfee.disjob.core.exception.KeyExistsException;
import cn.ponfee.disjob.core.model.SchedGroup;
import cn.ponfee.disjob.core.model.TokenType;
import cn.ponfee.disjob.core.param.supervisor.EventParam;
import cn.ponfee.disjob.core.param.worker.AuthenticationParam;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.supervisor.application.ServerInvokeService;
import cn.ponfee.disjob.supervisor.application.converter.SchedGroupConverter;
import cn.ponfee.disjob.supervisor.application.request.SchedGroupAddRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedGroupPageRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedGroupUpdateRequest;
import cn.ponfee.disjob.supervisor.application.response.SchedGroupResponse;
import cn.ponfee.disjob.supervisor.application.value.DisjobGroup;
import cn.ponfee.disjob.supervisor.configuration.SupervisorProperties;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedGroupMapper;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SchedGroupService
extends SingletonClassConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(SchedGroupService.class);
    private static final Lock LOCK = new ReentrantLock();
    private static volatile Map<String, DisjobGroup> groupMap;
    private static volatile Map<String, Set<String>> userMap;
    private final SchedGroupMapper schedGroupMapper;
    private final SupervisorRegistry supervisorRegistry;
    private final ServerInvokeService serverInvokeService;

    public SchedGroupService(SchedGroupMapper schedGroupMapper, SupervisorRegistry supervisorRegistry, ServerInvokeService serverInvokeService, SupervisorProperties supervisorProperties) {
        this.schedGroupMapper = schedGroupMapper;
        this.supervisorRegistry = supervisorRegistry;
        this.serverInvokeService = serverInvokeService;
        int periodSeconds = Math.max(supervisorProperties.getGroupRefreshPeriodSeconds(), 30);
        ThreadPoolExecutors.commonScheduledPool().scheduleWithFixedDelay(this::refresh, periodSeconds, periodSeconds, TimeUnit.SECONDS);
        this.refresh();
    }

    public long add(SchedGroupAddRequest request) {
        request.checkAndTrim();
        if (this.schedGroupMapper.exists(request.getGroup())) {
            throw new KeyExistsException("Group already exists: " + request.getGroup());
        }
        SchedGroup schedGroup = request.toSchedGroup();
        schedGroup.setUpdatedBy(schedGroup.getCreatedBy());
        this.schedGroupMapper.insert(schedGroup);
        this.refresh0();
        return schedGroup.getId();
    }

    public boolean delete(String group, String updatedBy) {
        List list = this.supervisorRegistry.getDiscoveredServers(group);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new KeyExistsException("Group '" + group + "' has registered workers, cannot delete.");
        }
        return Functions.doIfTrue((boolean)TransactionUtils.isOneAffectedRow((int)this.schedGroupMapper.softDelete(group, updatedBy)), this::refresh0);
    }

    public boolean edit(SchedGroupUpdateRequest request) {
        request.checkAndTrim();
        return Functions.doIfTrue((boolean)TransactionUtils.isOneAffectedRow((int)this.schedGroupMapper.edit(request.toSchedGroup())), this::refresh0);
    }

    public SchedGroupResponse get(String group) {
        SchedGroup schedGroup = this.schedGroupMapper.get(group);
        return SchedGroupConverter.INSTANCE.convert(schedGroup);
    }

    public boolean updateToken(String group, TokenType type, String newToken, String updatedBy, String oldToken) {
        return Functions.doIfTrue((boolean)TransactionUtils.isOneAffectedRow((int)this.schedGroupMapper.updateToken(group, type, newToken, updatedBy, oldToken)), this::refresh0);
    }

    public boolean updateOwnUser(String group, String ownUser, String updatedBy) {
        Assert.hasText((String)ownUser, (String)"Own user cannot be blank.");
        return Functions.doIfTrue((boolean)TransactionUtils.isOneAffectedRow((int)this.schedGroupMapper.updateOwnUser(group, ownUser.trim(), updatedBy)), this::refresh0);
    }

    public List<String> searchGroup(String term) {
        return this.schedGroupMapper.searchGroup(term);
    }

    public PageResponse<SchedGroupResponse> queryForPage(SchedGroupPageRequest pageRequest) {
        PageResponse page = pageRequest.query(this.schedGroupMapper::queryPageCount, this.schedGroupMapper::queryPageRecords, SchedGroupConverter.INSTANCE::convert);
        page.forEachRow(SchedGroupResponse::maskToken);
        return page;
    }

    public static Set<String> myGroups(String user) {
        Set<String> groups = userMap.get(user);
        return groups == null ? Collections.emptySet() : groups;
    }

    public static DisjobGroup getGroup(String group) {
        DisjobGroup disjobGroup = groupMap.get(group);
        if (disjobGroup == null) {
            throw new GroupNotFoundException("Not found worker group: " + group);
        }
        return disjobGroup;
    }

    public static boolean isDeveloper(String group, String user) {
        return SchedGroupService.getGroup(group).isDeveloper(user);
    }

    public static String createSupervisorAuthenticationToken(String group) {
        String supervisorToken = SchedGroupService.getGroup(group).getSupervisorToken();
        return Tokens.createAuthentication((String)supervisorToken, (TokenType)TokenType.supervisor, (String)group);
    }

    public static void fillSupervisorAuthenticationToken(String group, AuthenticationParam param) {
        param.setSupervisorToken(SchedGroupService.createSupervisorAuthenticationToken(group));
    }

    public static boolean verifyWorkerAuthenticationToken(String tokenSecret, String group) {
        String workerToken = SchedGroupService.getGroup(group).getWorkerToken();
        return Tokens.verifyAuthentication((String)tokenSecret, (String)workerToken, (TokenType)TokenType.worker, (String)group);
    }

    public static boolean verifyUserAuthenticationToken(String tokenSecret, String group) {
        String userToken = SchedGroupService.getGroup(group).getUserToken();
        return Tokens.verifyAuthentication((String)tokenSecret, (String)userToken, (TokenType)TokenType.user, (String)group);
    }

    public static boolean verifyWorkerSignatureToken(String tokenSecret, String group) {
        String workerToken = SchedGroupService.getGroup(group).getWorkerToken();
        return Tokens.verifySignature((String)tokenSecret, (String)workerToken, (TokenType)TokenType.worker, (String)group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh() {
        if (!LOCK.tryLock()) {
            return;
        }
        try {
            List<SchedGroup> list = this.schedGroupMapper.findAll();
            Map<String, DisjobGroup> groupMap0 = list.stream().collect(Collectors.toMap(SchedGroup::getGroup, DisjobGroup::of));
            Map<String, Set<String>> userMap0 = SchedGroupService.toUserMap(list);
            groupMap = groupMap0;
            userMap = userMap0;
        }
        catch (Throwable t) {
            LOG.error("Refresh sched group error.", t);
            Threads.interruptIfNecessary((Throwable)t);
        }
        finally {
            LOCK.unlock();
        }
    }

    private void refresh0() {
        this.refresh();
        this.serverInvokeService.publishOtherSupervisors(new EventParam(EventParam.Type.REFRESH_GROUP));
    }

    private static Map<String, Set<String>> toUserMap(List<SchedGroup> list) {
        Map<String, Set<String>> userMap = list.stream().flatMap(e -> {
            String group = e.getGroup();
            String devUsers = e.getDevUsers();
            if (StringUtils.isBlank((CharSequence)devUsers)) {
                return Stream.of(Pair.of((Object)e.getOwnUser(), (Object)group));
            }
            String[] array = devUsers.split(",");
            ArrayList<Pair> users = new ArrayList<Pair>(array.length + 1);
            users.add(Pair.of((Object)e.getOwnUser(), (Object)group));
            Arrays.stream(array).filter(StringUtils::isNotBlank).map(String::trim).forEach(u -> users.add(Pair.of((Object)u, (Object)group)));
            return users.stream();
        }).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, ImmutableSet.toImmutableSet())));
        return userMap;
    }
}

