/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.configuration;

import cn.ponfee.disjob.common.base.TripState;
import cn.ponfee.disjob.common.lock.DoInLocked;
import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.dispatch.TaskDispatcher;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.supervisor.SupervisorStartup;
import cn.ponfee.disjob.supervisor.component.DistributedJobManager;
import cn.ponfee.disjob.supervisor.component.DistributedJobQuerier;
import cn.ponfee.disjob.supervisor.configuration.SupervisorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.SmartLifecycle;

public class SupervisorLifecycle
implements SmartLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorLifecycle.class);
    private final TripState state = TripState.create();
    private final SupervisorStartup supervisorStartup;

    public SupervisorLifecycle(Supervisor.Current currentSupervisor, SupervisorProperties supervisorProperties, SupervisorRegistry supervisorRegistry, DistributedJobManager distributedJobManager, DistributedJobQuerier distributedJobQuerier, @Qualifier(value="disjob.bean.scan-triggering-job-locker") DoInLocked scanTriggeringJobLocker, @Qualifier(value="disjob.bean.scan-waiting-instance-locker") DoInLocked scanWaitingInstanceLocker, @Qualifier(value="disjob.bean.scan-running-instance-locker") DoInLocked scanRunningInstanceLocker, TaskDispatcher taskDispatcher) {
        this.supervisorStartup = SupervisorStartup.builder().currentSupervisor(currentSupervisor).supervisorProperties(supervisorProperties).supervisorRegistry(supervisorRegistry).distributedJobManager(distributedJobManager).distributedJobQuerier(distributedJobQuerier).scanTriggeringJobLocker(scanTriggeringJobLocker).scanWaitingInstanceLocker(scanWaitingInstanceLocker).scanRunningInstanceLocker(scanRunningInstanceLocker).taskDispatcher(taskDispatcher).build();
    }

    public boolean isRunning() {
        return this.state.isRunning();
    }

    public void start() {
        if (!this.state.start()) {
            LOG.error("Disjob supervisor lifecycle already stated!");
        }
        LOG.info("Disjob supervisor launch begin...");
        this.supervisorStartup.start();
        LOG.info("Disjob supervisor launch end.");
    }

    public void stop(Runnable callback) {
        if (!this.state.stop()) {
            LOG.error("Disjob supervisor lifecycle already stopped!");
        }
        LOG.info("Disjob supervisor stop begin...");
        this.supervisorStartup.stop();
        LOG.info("Disjob supervisor stop end.");
        callback.run();
    }

    public void stop() {
        this.stop(() -> {});
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }
}

