/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.configuration;

import cn.ponfee.disjob.common.base.ToJsonString;
import java.io.Serializable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="disjob.supervisor")
public class SupervisorProperties
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = -7896732123210543684L;
    public static final String KEY_PREFIX = "disjob.supervisor";
    private long scanTriggeringJobPeriodMs = 3000L;
    private long scanWaitingInstancePeriodMs = 15000L;
    private long scanRunningInstancePeriodMs = 30000L;
    private int processJobMaximumPoolSize = 5;
    private int groupRefreshPeriodSeconds = 120;
    private int jobScanFailedCountThreshold = 5;
    private int taskDispatchFailedCountThreshold = 3;

    public void check() {
        Assert.isTrue((this.scanTriggeringJobPeriodMs > 0L ? 1 : 0) != 0, (String)"Scan triggering job period ms must be greater than 0.");
        Assert.isTrue((this.scanWaitingInstancePeriodMs > 0L ? 1 : 0) != 0, (String)"Scan waiting instance period ms must be greater than 0.");
        Assert.isTrue((this.scanRunningInstancePeriodMs > 0L ? 1 : 0) != 0, (String)"Scan running instance period ms must be greater than 0.");
        Assert.isTrue((this.processJobMaximumPoolSize > 0 ? 1 : 0) != 0, (String)"Process job maximum pool size must be greater than 0.");
        Assert.isTrue((this.groupRefreshPeriodSeconds >= 30 ? 1 : 0) != 0, (String)"group refresh period seconds cannot less than 30s.");
        Assert.isTrue((this.jobScanFailedCountThreshold >= 0 ? 1 : 0) != 0, (String)"Job scan failed count threshold cannot less than 0.");
        Assert.isTrue((this.taskDispatchFailedCountThreshold >= 0 ? 1 : 0) != 0, (String)"Task dispatch failed count threshold cannot less than 0.");
    }

    public long getScanTriggeringJobPeriodMs() {
        return this.scanTriggeringJobPeriodMs;
    }

    public long getScanWaitingInstancePeriodMs() {
        return this.scanWaitingInstancePeriodMs;
    }

    public long getScanRunningInstancePeriodMs() {
        return this.scanRunningInstancePeriodMs;
    }

    public int getProcessJobMaximumPoolSize() {
        return this.processJobMaximumPoolSize;
    }

    public int getGroupRefreshPeriodSeconds() {
        return this.groupRefreshPeriodSeconds;
    }

    public int getJobScanFailedCountThreshold() {
        return this.jobScanFailedCountThreshold;
    }

    public int getTaskDispatchFailedCountThreshold() {
        return this.taskDispatchFailedCountThreshold;
    }

    public void setScanTriggeringJobPeriodMs(long scanTriggeringJobPeriodMs) {
        this.scanTriggeringJobPeriodMs = scanTriggeringJobPeriodMs;
    }

    public void setScanWaitingInstancePeriodMs(long scanWaitingInstancePeriodMs) {
        this.scanWaitingInstancePeriodMs = scanWaitingInstancePeriodMs;
    }

    public void setScanRunningInstancePeriodMs(long scanRunningInstancePeriodMs) {
        this.scanRunningInstancePeriodMs = scanRunningInstancePeriodMs;
    }

    public void setProcessJobMaximumPoolSize(int processJobMaximumPoolSize) {
        this.processJobMaximumPoolSize = processJobMaximumPoolSize;
    }

    public void setGroupRefreshPeriodSeconds(int groupRefreshPeriodSeconds) {
        this.groupRefreshPeriodSeconds = groupRefreshPeriodSeconds;
    }

    public void setJobScanFailedCountThreshold(int jobScanFailedCountThreshold) {
        this.jobScanFailedCountThreshold = jobScanFailedCountThreshold;
    }

    public void setTaskDispatchFailedCountThreshold(int taskDispatchFailedCountThreshold) {
        this.taskDispatchFailedCountThreshold = taskDispatchFailedCountThreshold;
    }
}

