/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.base;

import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.base.WorkerService;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.core.handle.JobHandlerUtils;
import cn.ponfee.disjob.core.handle.SplitTask;
import cn.ponfee.disjob.core.param.JobHandlerParam;
import cn.ponfee.disjob.registry.DiscoveryRestProxy;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkerServiceClient {
    private static final WorkerService LOCAL_WORKER_SERVICE = new WorkerService(){

        public void verify(JobHandlerParam param) throws JobException {
            JobHandlerUtils.verify((JobHandlerParam)param);
        }

        public List<SplitTask> split(JobHandlerParam param) throws JobException {
            return JobHandlerUtils.split((JobHandlerParam)param);
        }
    };
    private final WorkerService remoteWorkerService;
    private final Worker currentWorker;

    public WorkerServiceClient(@Nonnull WorkerService remoteWorkerService, @Nullable Worker currentWorker) {
        this.remoteWorkerService = Objects.requireNonNull(remoteWorkerService);
        this.currentWorker = currentWorker;
    }

    public void verify(JobHandlerParam param) throws JobException {
        this.get(param.getJobGroup()).verify(param);
    }

    public List<SplitTask> split(JobHandlerParam param) throws JobException {
        return this.get(param.getJobGroup()).split(param);
    }

    private WorkerService get(String group) {
        if (this.currentWorker != null && this.currentWorker.matchesGroup(group)) {
            return LOCAL_WORKER_SERVICE;
        }
        if (this.remoteWorkerService instanceof DiscoveryRestProxy.GroupedServer) {
            ((DiscoveryRestProxy.GroupedServer)this.remoteWorkerService).group(group);
        }
        return this.remoteWorkerService;
    }
}

