/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.configuration;

import cn.ponfee.disjob.common.lock.DoInDatabaseLocked;
import cn.ponfee.disjob.common.lock.DoInLocked;
import cn.ponfee.disjob.common.spring.LocalizedMethodArgumentConfigurer;
import cn.ponfee.disjob.common.spring.SpringContextHolder;
import cn.ponfee.disjob.common.util.ClassUtils;
import cn.ponfee.disjob.core.base.HttpProperties;
import cn.ponfee.disjob.core.base.RetryProperties;
import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.core.base.SupervisorService;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.base.WorkerService;
import cn.ponfee.disjob.core.openapi.supervisor.SupervisorOpenapi;
import cn.ponfee.disjob.core.util.JobUtils;
import cn.ponfee.disjob.registry.Discovery;
import cn.ponfee.disjob.registry.DiscoveryRestProxy;
import cn.ponfee.disjob.registry.DiscoveryRestTemplate;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.supervisor.SupervisorStartup;
import cn.ponfee.disjob.supervisor.base.WorkerServiceClient;
import cn.ponfee.disjob.supervisor.configuration.SupervisorLifecycle;
import cn.ponfee.disjob.supervisor.configuration.SupervisorProperties;
import cn.ponfee.disjob.supervisor.provider.SupervisorOpenapiProvider;
import cn.ponfee.disjob.supervisor.provider.SupervisorServiceProvider;
import cn.ponfee.disjob.supervisor.service.DistributedJobManager;
import cn.ponfee.disjob.supervisor.service.DistributedJobQuerier;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.lang.Nullable;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Documented
@EnableConfigurationProperties(value={SupervisorProperties.class})
@Import(value={EnableRetryProperties.class, EnableHttpProperties.class, EnableSupervisorConfiguration.class, EnableScanLockerConfiguration.class, EnableComponentScan.class, EnableSupervisorAdapter.class, SupervisorLifecycle.class})
public @interface EnableSupervisor {

    @Order
    @ConditionalOnProperty(prefix="disjob.supervisor", name={"locker"}, havingValue="default", matchIfMissing=true)
    public static class EnableScanLockerConfiguration {
        @ConditionalOnMissingBean(name={"scan-triggering-job-locker"})
        @Bean(value={"scan-triggering-job-locker"})
        public DoInLocked scanTriggeringJobLocker(@Qualifier(value="disjobJdbcTemplate") JdbcTemplate jdbcTemplate) {
            return new DoInDatabaseLocked(jdbcTemplate, "SELECT name FROM sched_lock WHERE name='scan_triggering_job' FOR UPDATE");
        }

        @ConditionalOnMissingBean(name={"scan-waiting-instance-locker"})
        @Bean(value={"scan-waiting-instance-locker"})
        public DoInLocked scanWaitingInstanceLocker(@Qualifier(value="disjobJdbcTemplate") JdbcTemplate jdbcTemplate) {
            return new DoInDatabaseLocked(jdbcTemplate, "SELECT name FROM sched_lock WHERE name='scan_waiting_instance' FOR UPDATE");
        }

        @ConditionalOnMissingBean(name={"scan-running-instance-locker"})
        @Bean(value={"scan-running-instance-locker"})
        public DoInLocked scanRunningInstanceLocker(@Qualifier(value="disjobJdbcTemplate") JdbcTemplate jdbcTemplate) {
            return new DoInDatabaseLocked(jdbcTemplate, "SELECT name FROM sched_lock WHERE name='scan_running_instance' FOR UPDATE");
        }
    }

    @ConditionalOnProperty(value={"server.port"})
    public static class EnableSupervisorAdapter {
        @DependsOn(value={"disjob.bean.current-supervisor"})
        @ConditionalOnMissingBean
        @Bean
        public SupervisorService supervisorService(DistributedJobManager jobManager, DistributedJobQuerier jobQuerier) {
            return new SupervisorServiceProvider(jobManager, jobQuerier);
        }

        @DependsOn(value={"disjob.bean.current-supervisor"})
        @ConditionalOnMissingBean
        @Bean
        public SupervisorOpenapi supervisorOpenapi(DistributedJobManager jobManager, DistributedJobQuerier jobQuerier) {
            return new SupervisorOpenapiProvider(jobManager, jobQuerier);
        }
    }

    @ComponentScan(basePackageClasses={SupervisorStartup.class})
    public static class EnableComponentScan {
    }

    @ConditionalOnProperty(value={"server.port"})
    public static class EnableSupervisorConfiguration {
        @AutoConfigureOrder(value=-2147483648)
        @Order(value=-2147483648)
        @ConditionalOnMissingBean
        @Bean(value={"disjob.bean.current-supervisor"})
        public Supervisor currentSupervisor(@Value(value="${server.port}") int port, @Value(value="${disjob.bound.server.host:}") String boundHost) {
            String host = JobUtils.getLocalHost((String)boundHost);
            Supervisor currentSupervisor = new Supervisor(host, port);
            try {
                ClassUtils.invoke(Class.forName(Supervisor.class.getName() + "$Current"), (String)"set", (Object[])new Object[]{currentSupervisor});
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError("Setting as current supervisor occur error.", e);
            }
            return currentSupervisor;
        }

        @DependsOn(value={"disjob.bean.current-supervisor"})
        @ConditionalOnMissingBean
        @Bean
        public WorkerServiceClient workerServiceClient(HttpProperties httpProperties, RetryProperties retryProperties, SupervisorRegistry supervisorRegistry, @Nullable Worker currentWorker, @Nullable ObjectMapper objectMapper) {
            httpProperties.check();
            retryProperties.check();
            DiscoveryRestTemplate discoveryRestTemplate = DiscoveryRestTemplate.builder().httpConnectTimeout(httpProperties.getConnectTimeout()).httpReadTimeout(httpProperties.getReadTimeout()).retryMaxCount(retryProperties.getMaxCount()).retryBackoffPeriod(retryProperties.getBackoffPeriod()).objectMapper(objectMapper).discoveryServer((Discovery)supervisorRegistry).build();
            WorkerService remoteWorkerService = (WorkerService)DiscoveryRestProxy.create((boolean)true, WorkerService.class, (DiscoveryRestTemplate)discoveryRestTemplate);
            return new WorkerServiceClient(remoteWorkerService, currentWorker);
        }

        @ConditionalOnMissingBean
        @Bean
        public LocalizedMethodArgumentConfigurer localizedMethodArgumentConfigurer() {
            return new LocalizedMethodArgumentConfigurer();
        }

        @ConditionalOnMissingBean
        @Bean
        public SpringContextHolder springContextHolder() {
            return new SpringContextHolder();
        }
    }

    @ConditionalOnMissingBean(value={HttpProperties.class})
    @EnableConfigurationProperties(value={HttpProperties.class})
    public static class EnableHttpProperties {
    }

    @ConditionalOnMissingBean(value={RetryProperties.class})
    @EnableConfigurationProperties(value={RetryProperties.class})
    public static class EnableRetryProperties {
    }
}

