/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.service;

import cn.ponfee.disjob.common.dag.DAGNode;
import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.common.model.PageResponse;
import cn.ponfee.disjob.core.dag.WorkflowGraph;
import cn.ponfee.disjob.core.enums.RunState;
import cn.ponfee.disjob.core.handle.execution.WorkflowPredecessorNode;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.core.model.SchedWorkflow;
import cn.ponfee.disjob.core.openapi.supervisor.converter.SchedJobConverter;
import cn.ponfee.disjob.core.openapi.supervisor.request.SchedInstancePageRequest;
import cn.ponfee.disjob.core.openapi.supervisor.request.SchedJobPageRequest;
import cn.ponfee.disjob.core.openapi.supervisor.response.SchedInstanceResponse;
import cn.ponfee.disjob.core.openapi.supervisor.response.SchedJobResponse;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedInstanceMapper;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedJobMapper;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedTaskMapper;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedWorkflowMapper;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Component;

@Component
public class DistributedJobQuerier {
    private final SchedJobMapper jobMapper;
    private final SchedTaskMapper taskMapper;
    private final SchedInstanceMapper instanceMapper;
    private final SchedWorkflowMapper workflowMapper;

    public DistributedJobQuerier(SchedJobMapper jobMapper, SchedTaskMapper taskMapper, SchedInstanceMapper instanceMapper, SchedWorkflowMapper workflowMapper) {
        this.jobMapper = jobMapper;
        this.taskMapper = taskMapper;
        this.instanceMapper = instanceMapper;
        this.workflowMapper = workflowMapper;
    }

    public SchedJob getJob(long jobId) {
        return this.jobMapper.getByJobId(jobId);
    }

    public SchedInstance getInstance(long instanceId) {
        return this.instanceMapper.getByInstanceId(instanceId);
    }

    public SchedInstance getInstance(long jobId, long triggerTime, int runType) {
        return this.instanceMapper.getByJobIdAndTriggerTimeAndRunType(jobId, triggerTime, runType);
    }

    public List<SchedJob> findBeTriggeringJob(long maxNextTriggerTime, int size) {
        return this.jobMapper.findBeTriggering(maxNextTriggerTime, size);
    }

    public List<SchedInstance> findExpireWaitingInstance(Date expireTime, int size) {
        return this.instanceMapper.findExpireState(RunState.WAITING.value(), expireTime.getTime(), expireTime, size);
    }

    public List<SchedInstance> findExpireRunningInstance(Date expireTime, int size) {
        return this.instanceMapper.findExpireState(RunState.RUNNING.value(), expireTime.getTime(), expireTime, size);
    }

    public List<SchedInstance> findUnterminatedRetryInstance(long rnstanceId) {
        return this.instanceMapper.findUnterminatedRetry(rnstanceId);
    }

    public List<SchedTask> findBaseInstanceTasks(long instanceId) {
        return this.taskMapper.findBaseByInstanceId(instanceId);
    }

    public SchedTask getTask(long taskId) {
        return this.taskMapper.getByTaskId(taskId);
    }

    public List<WorkflowPredecessorNode> getWorkflowPredecessorNodes(long wnstanceId, long instanceId) {
        List<SchedWorkflow> workflows = this.workflowMapper.findByWnstanceId(wnstanceId);
        if (CollectionUtils.isEmpty(workflows)) {
            return null;
        }
        SchedWorkflow curWorkflow = workflows.stream().filter(e -> e.getInstanceId() != null).filter(e -> e.getInstanceId() == instanceId).findAny().orElse(null);
        if (curWorkflow == null) {
            return null;
        }
        if (DAGNode.fromString((String)curWorkflow.getPreNode()).isStart()) {
            return null;
        }
        WorkflowGraph workflowGraph = new WorkflowGraph(workflows);
        DAGNode curNode = DAGNode.fromString((String)curWorkflow.getCurNode());
        Map predecessors = workflowGraph.predecessors(curNode);
        if (MapUtils.isEmpty((Map)predecessors)) {
            return null;
        }
        return predecessors.values().stream().map(e -> {
            List<SchedTask> tasks = this.taskMapper.findLargeByInstanceId(e.getInstanceId());
            tasks.sort(Comparator.comparing(SchedTask::getTaskNo));
            return WorkflowPredecessorNode.of((SchedWorkflow)e, tasks);
        }).sorted(Comparator.comparing(WorkflowPredecessorNode::getSequence)).collect(Collectors.toList());
    }

    public List<SchedTask> findLargeInstanceTasks(long instanceId) {
        return this.taskMapper.findLargeByInstanceId(instanceId);
    }

    public PageResponse<SchedJobResponse> queryJobForPage(SchedJobPageRequest pageRequest) {
        return pageRequest.query(this.jobMapper::queryPageCount, this.jobMapper::queryPageRecords, arg_0 -> ((SchedJobConverter)SchedJobConverter.INSTANCE).convert(arg_0));
    }

    public PageResponse<SchedInstanceResponse> queryInstanceForPage(SchedInstancePageRequest pageRequest) {
        if (pageRequest.getEndTime() != null) {
            pageRequest.setEndTime(Dates.endOfDay((Date)pageRequest.getEndTime()));
        }
        PageResponse pageResponse = pageRequest.query(this.instanceMapper::queryPageCount, this.instanceMapper::queryPageRecords, arg_0 -> ((SchedJobConverter)SchedJobConverter.INSTANCE).convert(arg_0));
        if (pageRequest.isParent()) {
            this.fillIsTreeLeaf(pageResponse.getRows());
        }
        return pageResponse;
    }

    public List<SchedInstanceResponse> listInstanceChildren(long pnstanceId) {
        List<SchedInstanceResponse> rows = this.instanceMapper.selectByPnstanceId(pnstanceId).stream().map(arg_0 -> ((SchedJobConverter)SchedJobConverter.INSTANCE).convert(arg_0)).collect(Collectors.toList());
        this.fillIsTreeLeaf(rows);
        return rows;
    }

    private void fillIsTreeLeaf(List<SchedInstanceResponse> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<Long> instanceIds = list.stream().map(SchedInstanceResponse::getInstanceId).collect(Collectors.toList());
        Map<Long, Integer> map = this.instanceMapper.queryChildCount(instanceIds).stream().collect(Collectors.toMap(e -> MapUtils.getLongValue((Map)e, (Object)"pnstanceId"), e -> MapUtils.getIntValue((Map)e, (Object)"count")));
        list.forEach(e -> {
            Integer count = (Integer)map.get(e.getInstanceId());
            e.setIsTreeLeaf(Integer.valueOf(count == null || count == 0 ? 0 : 1));
        });
    }
}

