/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.util;

import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.core.enums.MisfireStrategy;
import cn.ponfee.disjob.core.enums.TriggerType;
import cn.ponfee.disjob.core.model.SchedJob;
import java.util.Date;

public final class TriggerTimeUtils {
    public static Long computeNextTriggerTime(SchedJob job) {
        return TriggerTimeUtils.computeNextTriggerTime(job, new Date());
    }

    public static Long computeNextTriggerTime(SchedJob job, Date current) {
        Date next;
        TriggerType triggerType;
        if (job == null || (triggerType = TriggerType.of((Integer)job.getTriggerType())) == TriggerType.DEPEND) {
            return null;
        }
        MisfireStrategy misfireStrategy = MisfireStrategy.of((Integer)job.getMisfireStrategy());
        Date start = job.getStartTime();
        Date last = Dates.ofTimeMillis((Long)job.getLastTriggerTime());
        if (triggerType == TriggerType.ONCE) {
            if (last != null) {
                return null;
            }
            next = misfireStrategy == MisfireStrategy.DISCARD ? triggerType.computeNextFireTime(job.getTriggerValue(), current) : triggerType.computeNextFireTime(job.getTriggerValue(), new Date(0L));
        } else if (misfireStrategy == MisfireStrategy.DISCARD || last == null) {
            Date base = Dates.max((Date)Dates.max((Date)last, (Date)start), (Date)current);
            next = triggerType.computeNextFireTime(job.getTriggerValue(), base);
        } else {
            Date base = Dates.max((Date)last, (Date)start);
            switch (misfireStrategy) {
                case LAST: {
                    Date recently;
                    Date temp = null;
                    do {
                        recently = temp;
                        base = temp = triggerType.computeNextFireTime(job.getTriggerValue(), base);
                    } while (temp != null && temp.before(current));
                    next = recently != null ? recently : temp;
                    break;
                }
                case EVERY: {
                    next = triggerType.computeNextFireTime(job.getTriggerValue(), base);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported misfire strategy: " + job.getMisfireStrategy());
                }
            }
        }
        if (next == null) {
            return null;
        }
        Date end = job.getEndTime();
        return end != null && next.after(end) ? null : Long.valueOf(next.getTime());
    }
}

