/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.provider;

import cn.ponfee.disjob.common.model.PageResponse;
import cn.ponfee.disjob.common.model.Result;
import cn.ponfee.disjob.common.spring.BaseController;
import cn.ponfee.disjob.core.api.supervisor.SupervisorOpenRpcService;
import cn.ponfee.disjob.core.api.supervisor.request.AddSchedJobRequest;
import cn.ponfee.disjob.core.api.supervisor.request.SchedInstancePageRequest;
import cn.ponfee.disjob.core.api.supervisor.request.SchedJobPageRequest;
import cn.ponfee.disjob.core.api.supervisor.request.UpdateSchedJobRequest;
import cn.ponfee.disjob.core.api.supervisor.response.SchedInstanceResponse;
import cn.ponfee.disjob.core.api.supervisor.response.SchedJobResponse;
import cn.ponfee.disjob.core.api.supervisor.response.SchedTaskResponse;
import cn.ponfee.disjob.core.exception.JobCheckedException;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Supervisor open api")
@RestController
@RequestMapping(value={"supervisor/open/api"})
public class SupervisorOpenApiProvider
extends BaseController {
    private final SupervisorOpenRpcService supervisorOpenRpcService;

    public SupervisorOpenApiProvider(SupervisorOpenRpcService supervisorOpenRpcService) {
        this.supervisorOpenRpcService = supervisorOpenRpcService;
    }

    @PostMapping(value={"job/add"})
    public Result<Void> addJob(@RequestBody AddSchedJobRequest req) throws JobCheckedException {
        this.supervisorOpenRpcService.addJob(req);
        return Result.success();
    }

    @PutMapping(value={"job/update"})
    public Result<Void> updateJob(@RequestBody UpdateSchedJobRequest req) throws JobCheckedException {
        this.supervisorOpenRpcService.updateJob(req);
        return Result.success();
    }

    @DeleteMapping(value={"job/delete"})
    public Result<Void> deleteJob(@RequestParam(value="jobId") long jobId) {
        this.supervisorOpenRpcService.deleteJob(jobId);
        return Result.success();
    }

    @PostMapping(value={"job/state/change"})
    public Result<Boolean> changeJobState(@RequestParam(value="jobId") long jobId, @RequestParam(value="jobState") int jobState) {
        return Result.success((Object)this.supervisorOpenRpcService.changeJobState(jobId, jobState));
    }

    @PostMapping(value={"job/trigger"})
    public Result<Void> triggerJob(@RequestParam(value="jobId") long jobId) throws JobCheckedException {
        this.supervisorOpenRpcService.triggerJob(jobId);
        return Result.success();
    }

    @GetMapping(value={"job/get"})
    public Result<SchedJobResponse> getJob(@RequestParam(value="jobId") long jobId) {
        return Result.success((Object)this.supervisorOpenRpcService.getJob(jobId));
    }

    @GetMapping(value={"job/page"})
    public Result<PageResponse<SchedJobResponse>> queryJobForPage(SchedJobPageRequest pageRequest) {
        return Result.success((Object)this.supervisorOpenRpcService.queryJobForPage(pageRequest));
    }

    @PostMapping(value={"instance/pause"})
    public Result<Void> pauseInstance(@RequestParam(value="instanceId") long instanceId) {
        this.supervisorOpenRpcService.pauseInstance(instanceId);
        return Result.success();
    }

    @PostMapping(value={"instance/cancel"})
    public Result<Void> cancelInstance(@RequestParam(value="instanceId") long instanceId) {
        this.supervisorOpenRpcService.cancelInstance(instanceId);
        return Result.success();
    }

    @PostMapping(value={"instance/resume"})
    public Result<Void> resumeInstance(@RequestParam(value="instanceId") long instanceId) {
        this.supervisorOpenRpcService.resumeInstance(instanceId);
        return Result.success();
    }

    @DeleteMapping(value={"instance/delete"})
    public Result<Void> deleteInstance(@RequestParam(value="instanceId") long instanceId) {
        this.supervisorOpenRpcService.deleteInstance(instanceId);
        return Result.success();
    }

    @PostMapping(value={"instance/state/change"})
    public Result<Void> changeInstanceState(@RequestParam(value="instanceId") long instanceId, @RequestParam(value="targetExecuteState") int targetExecuteState) {
        this.supervisorOpenRpcService.changeInstanceState(instanceId, targetExecuteState);
        return Result.success();
    }

    @GetMapping(value={"instance/get"})
    public Result<SchedInstanceResponse> getInstance(@RequestParam(value="instanceId") long instanceId) {
        return Result.success((Object)this.supervisorOpenRpcService.getInstance(instanceId));
    }

    @GetMapping(value={"instance/tasks"})
    public Result<SchedInstanceResponse> getInstanceTasks(@RequestParam(value="instanceId") long instanceId) {
        return Result.success((Object)this.supervisorOpenRpcService.getInstanceTasks(instanceId));
    }

    @GetMapping(value={"tasks/get"})
    public Result<List<SchedTaskResponse>> getTasks(@RequestParam(value="instanceId") long instanceId) {
        return Result.success((Object)this.supervisorOpenRpcService.getTasks(instanceId));
    }

    @GetMapping(value={"instance/page"})
    public Result<PageResponse<SchedInstanceResponse>> queryInstanceForPage(SchedInstancePageRequest pageRequest) {
        return Result.success((Object)this.supervisorOpenRpcService.queryInstanceForPage(pageRequest));
    }

    @GetMapping(value={"instance/children"})
    public Result<List<SchedInstanceResponse>> listInstanceChildren(@RequestParam(value="pnstanceId") long pnstanceId) {
        return Result.success((Object)this.supervisorOpenRpcService.listInstanceChildren(pnstanceId));
    }
}

