/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.provider;

import cn.ponfee.disjob.common.model.CodeMsg;
import cn.ponfee.disjob.common.model.PageResponse;
import cn.ponfee.disjob.common.spring.RpcController;
import cn.ponfee.disjob.core.api.supervisor.SupervisorOpenRpcService;
import cn.ponfee.disjob.core.api.supervisor.converter.SchedJobConverter;
import cn.ponfee.disjob.core.api.supervisor.request.AddSchedJobRequest;
import cn.ponfee.disjob.core.api.supervisor.request.SchedInstancePageRequest;
import cn.ponfee.disjob.core.api.supervisor.request.SchedJobPageRequest;
import cn.ponfee.disjob.core.api.supervisor.request.UpdateSchedJobRequest;
import cn.ponfee.disjob.core.api.supervisor.response.SchedInstanceResponse;
import cn.ponfee.disjob.core.api.supervisor.response.SchedJobResponse;
import cn.ponfee.disjob.core.api.supervisor.response.SchedTaskResponse;
import cn.ponfee.disjob.core.base.JobCodeMsg;
import cn.ponfee.disjob.core.enums.ExecuteState;
import cn.ponfee.disjob.core.enums.JobState;
import cn.ponfee.disjob.core.enums.Operations;
import cn.ponfee.disjob.core.exception.JobCheckedException;
import cn.ponfee.disjob.core.exception.JobUncheckedException;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.supervisor.service.DistributedJobManager;
import cn.ponfee.disjob.supervisor.service.DistributedJobQuerier;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorOpenRpcProvider
implements SupervisorOpenRpcService,
RpcController {
    protected static final Logger LOG = LoggerFactory.getLogger(SupervisorOpenRpcProvider.class);
    private final DistributedJobManager jobManager;
    private final DistributedJobQuerier jobQuerier;

    public SupervisorOpenRpcProvider(DistributedJobManager jobManager, DistributedJobQuerier jobQuerier) {
        this.jobManager = jobManager;
        this.jobQuerier = jobQuerier;
    }

    public void addJob(AddSchedJobRequest req) throws JobCheckedException {
        this.jobManager.addJob(req.tosSchedJob());
    }

    public void updateJob(UpdateSchedJobRequest req) throws JobCheckedException {
        LOG.info("Do updating sched job {}", (Object)req.getJobId());
        this.jobManager.updateJob(req.tosSchedJob());
    }

    public void deleteJob(long jobId) {
        LOG.info("Do deleting sched job {}", (Object)jobId);
        this.jobManager.deleteJob(jobId);
    }

    public Boolean changeJobState(long jobId, int jobState) {
        LOG.info("Do change sched job state {}", (Object)jobId);
        return this.jobManager.changeJobState(jobId, JobState.of((Integer)jobState));
    }

    public void triggerJob(long jobId) throws JobCheckedException {
        LOG.info("Do manual trigger the sched job {}", (Object)jobId);
        this.jobManager.triggerJob(jobId);
    }

    public SchedJobResponse getJob(long jobId) {
        SchedJob schedJob = this.jobQuerier.getJob(jobId);
        return SchedJobConverter.INSTANCE.convert(schedJob);
    }

    public PageResponse<SchedJobResponse> queryJobForPage(SchedJobPageRequest pageRequest) {
        return this.jobQuerier.queryJobForPage(pageRequest);
    }

    public void pauseInstance(long instanceId) {
        LOG.info("Do pausing sched instance {}", (Object)instanceId);
        if (!this.jobManager.pauseInstance(instanceId)) {
            throw new JobUncheckedException((CodeMsg)JobCodeMsg.NOT_PAUSABLE_INSTANCE);
        }
    }

    public void cancelInstance(long instanceId) {
        LOG.info("Do canceling sched instance {}", (Object)instanceId);
        if (!this.jobManager.cancelInstance(instanceId, Operations.MANUAL_CANCEL)) {
            throw new JobUncheckedException((CodeMsg)JobCodeMsg.NOT_CANCELABLE_INSTANCE);
        }
    }

    public void resumeInstance(long instanceId) {
        LOG.info("Do resuming sched instance {}", (Object)instanceId);
        if (!this.jobManager.resumeInstance(instanceId)) {
            throw new JobUncheckedException((CodeMsg)JobCodeMsg.NOT_RESUMABLE_INSTANCE);
        }
    }

    public void changeInstanceState(long instanceId, int targetExecuteState) {
        ExecuteState.of((Integer)targetExecuteState);
        LOG.info("Do force change state {} | {}", (Object)instanceId, (Object)targetExecuteState);
        this.jobManager.changeInstanceState(instanceId, ExecuteState.of((Integer)targetExecuteState));
    }

    public void deleteInstance(long instanceId) {
        LOG.info("Do deleting sched instance {}", (Object)instanceId);
        this.jobManager.deleteInstance(instanceId);
    }

    public SchedInstanceResponse getInstance(long instanceId) {
        SchedInstance instance = this.jobQuerier.getInstance(instanceId);
        return instance == null ? null : SchedInstanceResponse.of((SchedInstance)instance, null);
    }

    public SchedInstanceResponse getInstanceTasks(long instanceId) {
        SchedInstance instance = this.jobQuerier.getInstance(instanceId);
        if (instance == null) {
            return null;
        }
        List<SchedTask> tasks = this.jobQuerier.findLargeInstanceTasks(instanceId);
        return SchedInstanceResponse.of((SchedInstance)instance, tasks);
    }

    public List<SchedTaskResponse> getTasks(long instanceId) {
        List<SchedTask> tasks = this.jobQuerier.findLargeInstanceTasks(instanceId);
        if (tasks == null) {
            return null;
        }
        return tasks.stream().map(arg_0 -> ((SchedJobConverter)SchedJobConverter.INSTANCE).convert(arg_0)).collect(Collectors.toList());
    }

    public PageResponse<SchedInstanceResponse> queryInstanceForPage(SchedInstancePageRequest pageRequest) {
        return this.jobQuerier.queryInstanceForPage(pageRequest);
    }

    public List<SchedInstanceResponse> listInstanceChildren(long pnstanceId) {
        return this.jobQuerier.listInstanceChildren(pnstanceId);
    }
}

