/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.service;

import cn.ponfee.disjob.common.base.IdGenerator;
import cn.ponfee.disjob.common.model.CodeMsg;
import cn.ponfee.disjob.core.base.JobCodeMsg;
import cn.ponfee.disjob.core.base.Server;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.enums.ExecuteState;
import cn.ponfee.disjob.core.enums.JobState;
import cn.ponfee.disjob.core.enums.Operations;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.enums.TriggerType;
import cn.ponfee.disjob.core.exception.JobCheckedException;
import cn.ponfee.disjob.core.handle.SplitTask;
import cn.ponfee.disjob.core.model.SchedDepend;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.core.param.ExecuteTaskParam;
import cn.ponfee.disjob.core.param.ExecuteTaskParamBuilder;
import cn.ponfee.disjob.core.param.JobHandlerParam;
import cn.ponfee.disjob.dispatch.TaskDispatcher;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.supervisor.base.WorkerCoreRpcClient;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedDependMapper;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedJobMapper;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public abstract class AbstractJobManager {
    private static final int MAX_SPLIT_TASK_SIZE = 1000;
    protected static final String TX_MANAGER_NAME = "disjobTransactionManager";
    protected static final int AFFECTED_ONE_ROW = 1;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final SchedJobMapper jobMapper;
    protected final SchedDependMapper dependMapper;
    private final IdGenerator idGenerator;
    private final SupervisorRegistry workerDiscover;
    private final TaskDispatcher taskDispatcher;
    private final WorkerCoreRpcClient workerCoreRpcClient;

    public boolean disableJob(SchedJob job) {
        return this.jobMapper.disable(job) == 1;
    }

    public boolean changeJobState(long jobId, JobState to) {
        return this.jobMapper.updateState(jobId, to.value(), 1 ^ to.value()) == 1;
    }

    public boolean updateJobNextTriggerTime(SchedJob job) {
        return this.jobMapper.updateNextTriggerTime(job) == 1;
    }

    public boolean updateJobNextScanTime(SchedJob schedJob) {
        return this.jobMapper.updateNextScanTime(schedJob) == 1;
    }

    @Transactional(transactionManager="disjobTransactionManager", rollbackFor={Exception.class})
    public void addJob(SchedJob job) throws JobCheckedException {
        job.setUpdatedBy(job.getCreatedBy());
        job.verifyBeforeAdd();
        job.checkAndDefaultSetting();
        this.workerCoreRpcClient.verify(JobHandlerParam.from((SchedJob)job));
        job.setJobId(Long.valueOf(this.generateId()));
        this.parseTriggerConfig(job);
        this.jobMapper.insert(job);
    }

    @Transactional(transactionManager="disjobTransactionManager", rollbackFor={Exception.class})
    public void updateJob(SchedJob job) throws JobCheckedException {
        job.verifyBeforeUpdate();
        job.checkAndDefaultSetting();
        if (StringUtils.isEmpty((CharSequence)job.getJobHandler())) {
            Assert.hasText((String)job.getJobParam(), (String)"Job param must be null if not set job handler.");
        } else {
            this.workerCoreRpcClient.verify(JobHandlerParam.from((SchedJob)job));
        }
        SchedJob dbJob = this.jobMapper.getByJobId(job.getJobId());
        Assert.notNull((Object)dbJob, () -> "Sched job id not found " + job.getJobId());
        job.setNextTriggerTime(dbJob.getNextTriggerTime());
        if (job.getTriggerType() == null) {
            Assert.isNull((Object)job.getTriggerValue(), (String)"Trigger value must be null if not set trigger type.");
        } else {
            Assert.notNull((Object)job.getTriggerValue(), (String)"Trigger value cannot be null if has set trigger type.");
            this.dependMapper.deleteByChildJobId(job.getJobId());
            this.parseTriggerConfig(job);
        }
        job.setUpdatedAt(new Date());
        Assert.state((this.jobMapper.updateByJobId(job) == 1 ? 1 : 0) != 0, (String)"Update sched job fail or conflict.");
    }

    @Transactional(transactionManager="disjobTransactionManager", rollbackFor={Exception.class})
    public void deleteJob(long jobId) {
        SchedJob job = this.jobMapper.getByJobId(jobId);
        Assert.notNull((Object)job, (String)("Job id not found: " + jobId));
        if (JobState.ENABLE.equals(job.getJobState())) {
            throw new IllegalStateException("Please disable job before delete this job.");
        }
        Assert.isTrue((this.jobMapper.deleteByJobId(jobId) == 1 ? 1 : 0) != 0, (String)"Delete sched job fail or conflict.");
        this.dependMapper.deleteByParentJobId(jobId);
        this.dependMapper.deleteByChildJobId(jobId);
    }

    public long generateId() {
        return this.idGenerator.generateId();
    }

    public List<SchedTask> splitTasks(JobHandlerParam param, long instanceId, Date date) throws JobCheckedException {
        if (RouteStrategy.BROADCAST == param.getRouteStrategy()) {
            List discoveredServers = this.workerDiscover.getDiscoveredServers(param.getJobGroup());
            if (discoveredServers.isEmpty()) {
                throw new JobCheckedException((CodeMsg)JobCodeMsg.NOT_DISCOVERED_WORKER);
            }
            int count = discoveredServers.size();
            return IntStream.range(0, count).mapToObj(i -> SchedTask.create((String)param.getJobParam(), (long)this.generateId(), (long)instanceId, (int)(i + 1), (int)count, (Date)date, (String)((Worker)discoveredServers.get(i)).serialize())).collect(Collectors.toList());
        }
        List<SplitTask> split = this.workerCoreRpcClient.split(param);
        Assert.notEmpty(split, () -> "Not split any task: " + param);
        Assert.isTrue((split.size() <= 1000 ? 1 : 0) != 0, () -> "Split task size must less than 1000, job=" + param);
        int count = split.size();
        return IntStream.range(0, count).mapToObj(i -> SchedTask.create((String)((SplitTask)split.get(i)).getTaskParam(), (long)this.generateId(), (long)instanceId, (int)(i + 1), (int)count, (Date)date, null)).collect(Collectors.toList());
    }

    public boolean hasAliveExecuting(List<SchedTask> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return false;
        }
        return tasks.stream().filter(e -> ExecuteState.EXECUTING.equals(e.getExecuteState())).map(SchedTask::getWorker).anyMatch(this::isAliveWorker);
    }

    public boolean isAliveWorker(String text) {
        return StringUtils.isNotBlank((CharSequence)text) && this.isAliveWorker(Worker.deserialize((String)text));
    }

    public boolean isDeadWorker(String text) {
        return !this.isAliveWorker(text);
    }

    public boolean isAliveWorker(Worker worker) {
        return worker != null && this.workerDiscover.isDiscoveredServer((Server)worker);
    }

    public boolean isDeadWorker(Worker worker) {
        return !this.isAliveWorker(worker);
    }

    public boolean hasNotDiscoveredWorkers(String group) {
        return CollectionUtils.isEmpty((Collection)this.workerDiscover.getDiscoveredServers(group));
    }

    public boolean hasNotDiscoveredWorkers() {
        return !this.workerDiscover.hasDiscoveredServers();
    }

    public boolean dispatch(SchedJob job, SchedInstance instance, List<SchedTask> tasks) {
        List<Object> list;
        ExecuteTaskParamBuilder builder = ExecuteTaskParam.builder((SchedInstance)instance, (SchedJob)job);
        if (RouteStrategy.BROADCAST.equals(job.getRouteStrategy())) {
            list = new ArrayList(tasks.size());
            for (SchedTask task : tasks) {
                Assert.hasText((String)task.getWorker(), () -> "Broadcast route strategy worker must pre assign: " + task.getTaskId());
                Worker worker = Worker.deserialize((String)task.getWorker());
                if (this.isDeadWorker(worker)) {
                    this.cancelWaitingTask(task.getTaskId());
                    continue;
                }
                list.add(builder.build(Operations.TRIGGER, task.getTaskId().longValue(), instance.getTriggerTime().longValue(), worker));
            }
        } else {
            list = tasks.stream().map(e -> builder.build(Operations.TRIGGER, e.getTaskId().longValue(), instance.getTriggerTime().longValue(), null)).collect(Collectors.toList());
        }
        return this.taskDispatcher.dispatch(list, job.getJobGroup());
    }

    public boolean dispatch(List<ExecuteTaskParam> params) {
        ArrayList<ExecuteTaskParam> list = new ArrayList<ExecuteTaskParam>(params.size());
        for (ExecuteTaskParam param : params) {
            if (RouteStrategy.BROADCAST == param.getRouteStrategy() && this.isDeadWorker(param.getWorker())) {
                this.cancelWaitingTask(param.getTaskId());
                continue;
            }
            list.add(param);
        }
        return this.taskDispatcher.dispatch(list);
    }

    protected abstract boolean cancelWaitingTask(long var1);

    private void parseTriggerConfig(SchedJob job) {
        TriggerType triggerType = TriggerType.of((Integer)job.getTriggerType());
        if (triggerType == TriggerType.DEPEND) {
            List<Long> parentJobIds = Arrays.stream(job.getTriggerValue().split(",")).filter(StringUtils::isNotBlank).map(e -> Long.parseLong(e.trim())).distinct().collect(Collectors.toList());
            Assert.notEmpty(parentJobIds, () -> "Invalid dependency parent job id config: " + job.getTriggerValue());
            Map parentJobMap = this.jobMapper.findByJobIds(parentJobIds).stream().collect(Collectors.toMap(SchedJob::getJobId, Function.identity()));
            for (Long parentJobId : parentJobIds) {
                SchedJob parentJob = (SchedJob)parentJobMap.get(parentJobId);
                Assert.notNull((Object)parentJob, () -> "Parent job id not found: " + parentJobId);
                if (job.getJobGroup().equals(parentJob.getJobGroup())) continue;
                throw new IllegalArgumentException("Invalid group: parent=" + parentJob.getJobGroup() + ", child=" + job.getJobGroup());
            }
            ArrayList<SchedDepend> list = new ArrayList<SchedDepend>(parentJobIds.size());
            for (int i = 0; i < parentJobIds.size(); ++i) {
                list.add(new SchedDepend(parentJobIds.get(i), job.getJobId(), Integer.valueOf(i + 1)));
            }
            this.dependMapper.batchInsert(list);
            job.setTriggerValue(Joiner.on((String)",").join(parentJobIds));
            job.setNextTriggerTime(null);
        } else {
            Date nextTriggerTime = triggerType.computeNextFireTime(job.getTriggerValue(), new Date());
            Assert.notNull((Object)nextTriggerTime, () -> "Has not next trigger time " + job.getTriggerValue());
            job.setNextTriggerTime(Long.valueOf(nextTriggerTime.getTime()));
        }
    }

    public AbstractJobManager(SchedJobMapper jobMapper, SchedDependMapper dependMapper, IdGenerator idGenerator, SupervisorRegistry workerDiscover, TaskDispatcher taskDispatcher, WorkerCoreRpcClient workerCoreRpcClient) {
        this.jobMapper = jobMapper;
        this.dependMapper = dependMapper;
        this.idGenerator = idGenerator;
        this.workerDiscover = workerDiscover;
        this.taskDispatcher = taskDispatcher;
        this.workerCoreRpcClient = workerCoreRpcClient;
    }
}

