/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.base;

import cn.ponfee.disjob.core.base.HttpProperties;
import cn.ponfee.disjob.core.base.RetryProperties;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.base.WorkerCoreRpcService;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.core.handle.JobHandlerUtils;
import cn.ponfee.disjob.core.handle.SplitTask;
import cn.ponfee.disjob.core.param.JobHandlerParam;
import cn.ponfee.disjob.registry.Discovery;
import cn.ponfee.disjob.registry.DiscoveryRestProxy;
import cn.ponfee.disjob.registry.DiscoveryRestTemplate;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.annotation.Nullable;

public class WorkerCoreRpcClient {
    private final Worker currentWorker;
    private final WorkerCoreRpcService local;
    private final WorkerCoreRpcService remote;

    public WorkerCoreRpcClient(HttpProperties httpProperties, RetryProperties retryProperties, SupervisorRegistry supervisorRegistry, @Nullable Worker currentWorker, @Nullable ObjectMapper objectMapper) {
        httpProperties.check();
        retryProperties.check();
        DiscoveryRestTemplate discoveryRestTemplate = DiscoveryRestTemplate.builder().httpConnectTimeout(httpProperties.getConnectTimeout()).httpReadTimeout(httpProperties.getReadTimeout()).retryMaxCount(retryProperties.getMaxCount()).retryBackoffPeriod(retryProperties.getBackoffPeriod()).objectMapper(objectMapper).discoveryServer((Discovery)supervisorRegistry).build();
        this.currentWorker = currentWorker;
        this.local = WorkerCoreRpcLocal.INSTANCE;
        this.remote = (WorkerCoreRpcService)DiscoveryRestProxy.create((boolean)true, WorkerCoreRpcService.class, (DiscoveryRestTemplate)discoveryRestTemplate);
    }

    public void verify(JobHandlerParam param) throws JobException {
        this.grouped(param.getJobGroup()).verify(param);
    }

    public List<SplitTask> split(JobHandlerParam param) throws JobException {
        return this.grouped(param.getJobGroup()).split(param);
    }

    private WorkerCoreRpcService grouped(String group) {
        if (this.currentWorker != null && this.currentWorker.matchesGroup(group)) {
            return this.local;
        }
        ((DiscoveryRestProxy.GroupedServer)this.remote).group(group);
        return this.remote;
    }

    private static class WorkerCoreRpcLocal
    implements WorkerCoreRpcService {
        private static final WorkerCoreRpcLocal INSTANCE = new WorkerCoreRpcLocal();

        private WorkerCoreRpcLocal() {
        }

        public void verify(JobHandlerParam param) throws JobException {
            JobHandlerUtils.verify((JobHandlerParam)param);
        }

        public List<SplitTask> split(JobHandlerParam param) throws JobException {
            return JobHandlerUtils.split((JobHandlerParam)param);
        }
    }
}

