/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.instance;

import cn.ponfee.disjob.core.enums.JobType;
import cn.ponfee.disjob.core.enums.RunType;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.core.model.SchedJob;
import cn.ponfee.disjob.supervisor.instance.NormalInstanceCreator;
import cn.ponfee.disjob.supervisor.instance.TriggerInstance;
import cn.ponfee.disjob.supervisor.instance.WorkflowInstanceCreator;
import cn.ponfee.disjob.supervisor.service.DistributedJobManager;

public abstract class TriggerInstanceCreator<T extends TriggerInstance> {
    protected final DistributedJobManager jobManager;

    public TriggerInstanceCreator(DistributedJobManager jobManager) {
        this.jobManager = jobManager;
    }

    public final void createWithSaveAndDispatch(SchedJob job, RunType runType, long triggerTime) throws JobException {
        T triggerInstance = this.create(job, runType, triggerTime);
        if (this.jobManager.createInstance(job, (TriggerInstance)triggerInstance)) {
            this.dispatch(job, triggerInstance);
        }
    }

    public abstract T create(SchedJob var1, RunType var2, long var3) throws JobException;

    public abstract void dispatch(SchedJob var1, T var2);

    public static TriggerInstanceCreator<?> of(Integer jobType, DistributedJobManager jobManager) {
        switch (JobType.of((Integer)jobType)) {
            case GENERAL: {
                return new NormalInstanceCreator(jobManager);
            }
            case WORKFLOW: {
                return new WorkflowInstanceCreator(jobManager);
            }
        }
        throw new UnsupportedOperationException("Unknown job type: " + jobType);
    }
}

