/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.common.concurrent.LoopThread;
import cn.ponfee.disjob.common.concurrent.Threads;
import cn.ponfee.disjob.common.model.PageResponse;
import cn.ponfee.disjob.common.spring.TransactionUtils;
import cn.ponfee.disjob.common.util.Functions;
import cn.ponfee.disjob.core.exception.GroupNotFoundException;
import cn.ponfee.disjob.core.exception.KeyExistsException;
import cn.ponfee.disjob.core.model.SchedGroup;
import cn.ponfee.disjob.supervisor.application.converter.SchedGroupConverter;
import cn.ponfee.disjob.supervisor.application.request.AddSchedGroupRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedGroupPageRequest;
import cn.ponfee.disjob.supervisor.application.request.UpdateSchedGroupRequest;
import cn.ponfee.disjob.supervisor.application.response.SchedGroupResponse;
import cn.ponfee.disjob.supervisor.application.value.DisjobGroup;
import cn.ponfee.disjob.supervisor.application.value.TokenName;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedGroupMapper;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component
public class SchedGroupService
extends SingletonClassConstraint
implements Closeable,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(SchedGroupService.class);
    private static final Lock LOCK = new ReentrantLock();
    private static volatile Map<String, DisjobGroup> groupMap;
    private static volatile Map<String, Set<String>> userMap;
    private final SchedGroupMapper schedGroupMapper;
    private final LoopThread refresher;

    public SchedGroupService(SchedGroupMapper schedGroupMapper) {
        this.schedGroupMapper = schedGroupMapper;
        this.refresher = new LoopThread("group_metadata_refresher", 60L, 60L, this::refresh);
        this.refresh();
    }

    @Transactional(transactionManager="disjobTransactionManager", rollbackFor={Exception.class})
    public long add(AddSchedGroupRequest request) {
        request.checkAndTrim();
        if (this.schedGroupMapper.exists(request.getGroup())) {
            throw new KeyExistsException("Group already exists: " + request.getGroup());
        }
        SchedGroup schedGroup = request.toSchedGroup();
        schedGroup.setUpdatedBy(schedGroup.getCreatedBy());
        this.schedGroupMapper.insert(schedGroup);
        this.refresh();
        return schedGroup.getId();
    }

    @Transactional(transactionManager="disjobTransactionManager", rollbackFor={Exception.class})
    public boolean delete(String group, String updatedBy) {
        return Functions.doIfTrue((boolean)TransactionUtils.isOneAffectedRow((int)this.schedGroupMapper.softDelete(group, updatedBy)), this::refresh);
    }

    @Transactional(transactionManager="disjobTransactionManager", rollbackFor={Exception.class})
    public boolean edit(UpdateSchedGroupRequest request) {
        request.checkAndTrim();
        return Functions.doIfTrue((boolean)TransactionUtils.isOneAffectedRow((int)this.schedGroupMapper.edit(request.toSchedGroup())), this::refresh);
    }

    public SchedGroupResponse get(String group) {
        SchedGroup schedGroup = this.schedGroupMapper.get(group);
        return SchedGroupConverter.INSTANCE.convert(schedGroup);
    }

    public boolean updateToken(String group, TokenName name, String newToken, String updatedBy, String oldToken) {
        return Functions.doIfTrue((boolean)TransactionUtils.isOneAffectedRow((int)this.schedGroupMapper.updateToken(group, name, newToken, updatedBy, oldToken)), this::refresh);
    }

    public boolean updateOwnUser(String group, String ownUser, String updatedBy) {
        Assert.hasText((String)ownUser, (String)"Own user cannot be blank.");
        return Functions.doIfTrue((boolean)TransactionUtils.isOneAffectedRow((int)this.schedGroupMapper.updateOwnUser(group, ownUser, updatedBy)), this::refresh);
    }

    public List<String> matchGroup(String term) {
        return this.schedGroupMapper.matchGroup(term);
    }

    public PageResponse<SchedGroupResponse> queryForPage(SchedGroupPageRequest pageRequest) {
        pageRequest.truncateGroup();
        return pageRequest.query(this.schedGroupMapper::queryPageCount, this.schedGroupMapper::queryPageRecords, SchedGroupConverter.INSTANCE::convert);
    }

    @Override
    public void close() {
        this.refresher.terminate();
    }

    public void destroy() {
        this.close();
    }

    public static DisjobGroup mapGroup(String group) {
        DisjobGroup disjobGroup = groupMap.get(group);
        if (disjobGroup == null) {
            throw new GroupNotFoundException("Not found worker group: " + group);
        }
        return disjobGroup;
    }

    public static Set<String> mapUser(String user) {
        Set<String> groups = userMap.get(user);
        return groups == null ? Collections.emptySet() : groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        if (!LOCK.tryLock()) {
            return;
        }
        try {
            List<SchedGroup> list = this.schedGroupMapper.findAll();
            Map<String, DisjobGroup> groupMap0 = list.stream().collect(Collectors.toMap(SchedGroup::getGroup, DisjobGroup::of));
            Map<String, Set<String>> userMap0 = SchedGroupService.toUserMap(list);
            groupMap = groupMap0;
            userMap = userMap0;
        }
        catch (Throwable t) {
            LOG.error("Refresh sched group error.", t);
            Threads.interruptIfNecessary((Throwable)t);
        }
        finally {
            LOCK.unlock();
        }
    }

    private static Map<String, Set<String>> toUserMap(List<SchedGroup> list) {
        Map<String, Set<String>> userMap = list.stream().flatMap(e -> {
            String group = e.getGroup();
            String devUsers = e.getDevUsers();
            if (StringUtils.isBlank((CharSequence)devUsers)) {
                return Stream.of(Pair.of((Object)e.getOwnUser(), (Object)group));
            }
            String[] array = devUsers.split(",");
            ArrayList<Pair> users = new ArrayList<Pair>(array.length + 1);
            users.add(Pair.of((Object)e.getOwnUser(), (Object)group));
            for (String user : array) {
                users.add(Pair.of((Object)user, (Object)group));
            }
            return users.stream();
        }).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, ImmutableSet.toImmutableSet())));
        return userMap;
    }
}

