/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.common.spring.RestTemplateUtils;
import cn.ponfee.disjob.core.base.HttpProperties;
import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.core.base.SupervisorMetrics;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.base.WorkerMetrics;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.supervisor.application.converter.ServerMetricsConverter;
import cn.ponfee.disjob.supervisor.application.response.SupervisorMetricsResponse;
import cn.ponfee.disjob.supervisor.application.response.WorkerMetricsResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class ServerMetricsService
extends SingletonClassConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(ServerMetricsService.class);
    private static final String SUPERVISOR_METRICS_URL = "http://%s:%d/supervisor/rpc/metrics";
    private static final String WORKER_METRICS_URL = "http://%s:%d/worker/rpc/metrics";
    private final RestTemplate restTemplate;
    private final SupervisorRegistry supervisorRegistry;

    public ServerMetricsService(HttpProperties http, ObjectMapper objectMapper, SupervisorRegistry supervisorRegistry) {
        MappingJackson2HttpMessageConverter httpMessageConverter = new MappingJackson2HttpMessageConverter();
        httpMessageConverter.setObjectMapper(objectMapper);
        RestTemplateUtils.extensionSupportedMediaTypes((MappingJackson2HttpMessageConverter)httpMessageConverter);
        this.restTemplate = RestTemplateUtils.buildRestTemplate((int)http.getConnectTimeout(), (int)http.getReadTimeout(), (Charset)StandardCharsets.UTF_8, (MappingJackson2HttpMessageConverter)httpMessageConverter);
        this.supervisorRegistry = supervisorRegistry;
    }

    public List<SupervisorMetricsResponse> supervisors() throws Exception {
        List list = this.supervisorRegistry.getRegisteredServers();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        return list.stream().sorted(Comparator.comparing(e -> e.equals((Object)Supervisor.current()) ? 0 : 1)).map(e -> CompletableFuture.supplyAsync(() -> this.convert((Supervisor)e))).collect(Collectors.toList()).stream().map(CompletableFuture::join).collect(Collectors.toList());
    }

    public List<WorkerMetricsResponse> workers(String group) {
        List list = this.supervisorRegistry.getDiscoveredServers(group);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        return list.stream().sorted(Comparator.comparing(e -> e.equals((Object)Worker.current()) ? 0 : 1)).map(e -> CompletableFuture.supplyAsync(() -> this.convert((Worker)e))).collect(Collectors.toList()).stream().map(CompletableFuture::join).collect(Collectors.toList());
    }

    private SupervisorMetricsResponse convert(Supervisor supervisor) {
        SupervisorMetrics metrics = null;
        Long pingTime = null;
        String url = String.format(SUPERVISOR_METRICS_URL, supervisor.getHost(), supervisor.getPort());
        try {
            long start = System.currentTimeMillis();
            metrics = (SupervisorMetrics)this.restTemplate.getForObject(url, SupervisorMetrics.class, new Object[0]);
            pingTime = System.currentTimeMillis() - start;
        }
        catch (Throwable e) {
            LOG.warn("Ping supervisor occur error: {} {}", (Object)supervisor, (Object)e.getMessage());
        }
        SupervisorMetricsResponse response = metrics == null ? new SupervisorMetricsResponse() : ServerMetricsConverter.INSTANCE.convert(metrics);
        response.setHost(supervisor.getHost());
        response.setPort(supervisor.getPort());
        response.setPingTime(pingTime);
        return response;
    }

    private WorkerMetricsResponse convert(Worker worker) {
        WorkerMetrics metrics = null;
        Long pingTime = null;
        String url = String.format(WORKER_METRICS_URL, worker.getHost(), worker.getPort());
        try {
            long start = System.currentTimeMillis();
            metrics = (WorkerMetrics)this.restTemplate.getForObject(url, WorkerMetrics.class, new Object[0]);
            pingTime = System.currentTimeMillis() - start;
        }
        catch (Throwable e) {
            LOG.warn("Ping worker occur error: {} {}", (Object)worker, (Object)e.getMessage());
        }
        WorkerMetricsResponse response = metrics == null ? new WorkerMetricsResponse() : ServerMetricsConverter.INSTANCE.convert(metrics);
        response.setHost(worker.getHost());
        response.setPort(worker.getPort());
        response.setWorkerId(worker.getWorkerId());
        response.setPingTime(pingTime);
        return response;
    }
}

